/**
 * 
 */
package gov.va.med.nhin.adapter.audit.requests;

import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookupLocal;

import javax.ejb.EJB;
import javax.ejb.*;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import org.apache.commons.lang3.StringUtils;

/**
 * @author vhaiswchmarc
 * 
 */
@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
@Stateless(name = "RequestAudit", mappedName = "RequestAudit")
public class RequestAuditImpl implements RequestAudit {
	private EntityManager entityManager;
	private PropertyLookup propertyLookup;

	@PersistenceContext
	public void setEntityManager(EntityManager entityManager) {
		this.entityManager = entityManager;
	}

	@EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyFileLookup")
	public void setPropertyLookup(PropertyLookup propertyLookup) {
		this.propertyLookup = propertyLookup;
	}

	public boolean isAuditEnabled() {
		String property = propertyLookup.getProperty("REQUEST_AUDIT_ENABLED");

		if (StringUtils.isNotBlank(property)) {
			return Boolean.parseBoolean(property);
		}

		return false;
	}

        @TransactionAttribute(value = TransactionAttributeType.REQUIRED)
	public void storeAudit(final RequestAuditEntity entity) {
		if (StringUtils.isBlank(entity.getUuid())) {
			entity.generateUUID();
		}

		// Currently this context is setup for write new objects only. However
		// in the future this may be expanded.
		if (isAuditEnabled()) {
			if (entity.getRequestId() == null) {
				entityManager.persist(entity);
			} else {
				entityManager.merge(entity);
			}
		}
	}

}
