/**
 * 
 */
package gov.va.med.nhin.adapter.audit.requests;

/**
 * Interface that creates the Request Auditing contract.
 * 
 * @author vhaiswchmarc
 * 
 */
public interface RequestAudit {
	/**
	 * Method that will perform a look up to determine if an audit should occur,
	 * beased on some property settings.
	 * 
	 * @return
	 */
	public boolean isAuditEnabled();
	
	/**
	 * Method used to store the entity into the auditing location of choice.
	 * 
	 * @param entity
	 */
	public void storeAudit(final RequestAuditEntity entity);
}
