import shutil

def connectToServer():
  try:
    try:
      connect(username, password, url)
    except NameError:
      connect()
  except WLSTException:
    print "There was a problem connecting to server."

def disconnectFromServer():
  if connected=="true":
    disconnect(force="true")
    
def startManagedServer():
    start(name=targets, type=targetsType)
  
def stopManagedServer():
  try:
      shutdown(name=targets, entityType=targetsType, force="true")
  except WLSTException:
    print "Managed server appears to be stopped already."

def deploy_AdapterEA():
  print "Deploying AdapterEA-" + adapterVersion + ".ear"
  deploy("AdapterEA-" + adapterVersion, domainDir + "/stage/AdapterEA-" + adapterVersion + ".ear",targets,securityModel="CustomRoles",block="true")

def undeploy_NHINAdapterLIB():
  try:
    undeploy("NHINAdapterLIB", targets, block="true")
  except:
    print "Could not undeploy NHINAdapterLIB."

def undeploy_NHINAdapterCommonEA():
  try:
    undeploy("NHINAdapterCommonEA", targets, block="true")
  except:
    print "Could not undeploy NHINAdapterCommonEA."

def undeploy_NHINAdapterEA():
  try:
    undeploy("NHINAdapterEA", targets, block="true")
  except:
    print "Could not undeploy NHINAdapterEA."

def startTransaction():
  edit()
  startEdit()
  
def commitTransaction():
  save()
  activate(block='true')

def rollbackTransaction():
  undo()
  stopEdit()

from shutil import copy2
from glob import glob
from os import sep
from os import makedirs
from os.path import exists
import stat
def copyFiles(src, dst, files):
  for f in files.split(":"):
    srcFile = src + "/" + f
    for g in glob(srcFile):
      dstFile = dst + g[len(src):len(g)]
      dstPath = sep.join(dstFile.split(sep)[0:-1])
      if exists(dstPath) == False:
        makedirs(dstPath)
      copy2(g, dstPath)


from glob import glob
import os 
from os.path import exists
import stat
def delFiles(src, files):
  for f in files.split(":"):
    srcFile = src + "/" + f
    for g in glob(srcFile):
      if exists(g):
        os.remove(g)

def deploy_VistALinkResourceAdapters():
   directories = []
   for file in os.listdir(vistALinkRAStageDir):
       directories.append(file);

   for d in directories:
       deploy(d, vistALinkRAStageDir + "/" + d, targets, block="true")

def main():
  hideDisplay()
  hideDumpStack('true')
  loadProperties("install.properties")
  try:
    if exists("backup") == False:
      disconnectFromServer()
      connectToServer()

      if connected=="true":
      	print("Backing up files.")
      	copyFiles(domainDir, "backup", backupFiles)
        
        print("Deleting unused files.")
        delFiles(domainDir, deleteFiles)
        
        print("Copying new files to domain.")
      	copyFiles(".", domainDir, installFiles)
        
        if restartServer=="true":
        	stopManagedServer()

      	startTransaction()
      	try:
      	  undeploy_NHINAdapterEA()
      	  undeploy_NHINAdapterCommonEA()
      	  undeploy_NHINAdapterLIB()
      	  deploy_AdapterEA()
          if deployVistALinkResourceAdapters=="true":
      	    deploy_VistALinkResourceAdapters()
      	except:
	  delFiles(domainDir, installFiles)
      	  copyFiles("backup", domainDir, backupFiles)
	  rollbackTransaction()
      	else:
      	  commitTransaction()
      
        if restartServer=="true":
      	  startManagedServer()
      else:
        print "Failed to connect to server."
    else:
      print "NHIN Adapter has already been installed."
      
  finally:
    disconnectFromServer()
    hideDumpStack('false')
    
main()
