#!/bin/sh

echo "Installing Desktop"
yum -y groupinstall "Desktop" "Desktop Platform" "X Window System" "Fonts"
yum -y install xorg-x11-apps xterm zip unzip vim bc net-tools httpd mod_ssl

echo "Adding oracle user."
groupadd dba
useradd oracle -g dba
mkdir -p /u01/app
chown -R oracle:dba /u01/app

echo "Adding vagrant to dba group."
usermod -a -G dba vagrant

echo "Downloading installers..."
if [ ! -d /ehx/.vagrant/Software/ehx ]; then
  mkdir -p /ehx/.vagrant/Software/ehx
  curl https://downloads.vetsez.net/Downloads/jdk-8u121-linux-x64.tar.gz -o /ehx/.vagrant/Software/ehx/jdk-8u121-linux-x64.tar.gz
  curl https://downloads.vetsez.net/Downloads/fmw_12.2.1.2.0_wls_Disk1_1of1.zip -o /ehx/.vagrant/Software/ehx/fmw_12.2.1.2.0_wls_Disk1_1of1.zip
  curl https://downloads.vetsez.net/Downloads/oracle-xe-11.2.0-1.0.x86_64.rpm.zip -o /ehx/.vagrant/Software/ehx/oracle-xe-11.2.0-1.0.x86_64.rpm.zip
fi

echo "Installing JDK."
runuser -l oracle << STOP
mkdir -p /u01/app/oracle/java
tar -C /u01/app/oracle/java -xzf /ehx/.vagrant/Software/ehx/jdk-8u121-linux-x64.tar.gz
pushd /u01/app/oracle/java
ln -s jdk1.8.0_121 latest
popd
STOP

echo "Instaling weblogic"
runuser -l oracle << STOP
echo "  Creating oraInst.loc."
mkdir -p /u01/app/oracle/oraInventory
cat << STOP2 >/u01/app/oracle/oraInventory/oraInst.loc
inventory_loc=/u01/app/oracle/oraInventory
inst_group=dba
STOP2
echo "  Running WebLogic Installer."
export JAVA_HOME=/u01/app/oracle/java/latest
pushd /tmp
unzip /ehx/.vagrant/Software/ehx/fmw_12.2.1.2.0_wls_Disk1_1of1.zip
/u01/app/oracle/java/latest/bin/java -Djava.security.egd=file:/dev/./urandom -jar fmw_12.2.1.2.0_wls.jar -silent -responseFile /ehx/vagrant-scripts/wls.rsp -invPtrLoc /u01/app/oracle/oraInventory/oraInst.loc
popd
echo "  Configure WebLogic to use /dev/urandom."
cat << STOP2 >>/u01/app/oracle/weblogic/oracle_common/common/bin/commBaseEnv.sh
# use /dev/urandom to generate random numbers to speed up weblogic.
# change made here so that everything we use in WL installation
# can benefit.
export JAVA_OPTIONS="\\\$JAVA_OPTIONS -Djava.security.egd=file:/dev/./urandom"
export CONFIG_JVM_ARGS="\\\$CONFIG_JVM_ARGS -Djava.security.egd=file:/dev/./urandom"
STOP2
STOP

echo "Installing Oracle XE"
# trick XE installer into thinking we have 2GB of swap space.
mv /usr/bin/free /usr/bin/free.bak
printf "#!/bin/sh\necho Swap - - 2048" >/usr/bin/free
chmod +x /usr/bin/free
# end trick
unzip /ehx/.vagrant/Software/ehx/oracle-xe-11.2.0-1.0.x86_64.rpm.zip -d /tmp/XE
pushd /tmp/XE/Disk1
rpm -ivh oracle-xe-11.2.0-1.0.x86_64.rpm >/tmp/XE/install.log
ORA_INSTALL_STATUS=$?
/etc/init.d/oracle-xe configure responseFile=/ehx/vagrant-scripts/xe.rsp >>/tmp/XE/install.log
popd
if [ $ORA_INSTALL_STATUS -ne 0 ]; 
then
    echo -e "\nOracle RDBMS 11g was not installed successfully. There are some problems installing it.\nLook into the log for more details, /tmp/XE/install.log. \nExiting...."
    exit $ORA_INSTALL_STATUS
else 
    echo -e "Oracle RDBMS 11g was installed successfully. ORA_INSTALL_STATUS=$ORA_INSTALL_STATUS. \n"
fi
# undo trick
rm -f /usr/bin/free
mv /usr/bin/free.bak /usr/bin/free
# end undo trick

echo "Add Java, Oracle and WebLogic to paths."
tee -a ~vagrant/.bash_profile ~oracle/.bash_profile << STOP
export JAVA_HOME=/u01/app/oracle/java/latest
export WL_HOME=/u01/app/oracle/weblogic
export PATH=\$WL_HOME/oracle_common/common/bin:\$JAVA_HOME/bin:\$PATH
. /u01/app/oracle/product/11.2.0/xe/bin/oracle_env.sh
STOP
tee -a ~vagrant/.bashrc ~oracle/.bashrc << STOP
alias debugwl='cd /u01/app/domains/ehx_devl && ./startDomainDebug.sh && tail -f servers/admin/logs/ehx_devl.out'
alias debugwlm='cd /u01/app/domains/ehx_devl && ./startDomainDebugWithMocks.sh && tail -f servers/admin/logs/ehx_devl.out'
alias stopwl='cd /u01/app/domains/ehx_devl && bin/stopWebLogic.sh'
alias logwl='cd /u01/app/domains/ehx_devl && tail -f servers/admin/logs/ehx_devl.out'
STOP

echo "Give everyone in dba group write privs on /u01/app."
chmod -R g+w /u01/app

echo -e "\nSet up the ADAPTER schema.  Look in /tmp/BuildDB.log for log output."
runuser -l oracle << STOP
pushd /ehx/DBScripts
. ./BuildDB.sh &>/tmp/BuildDB.log
popd
STOP

echo "Set up ehx_devl weblogic domain."
runuser -l vagrant << STOP
wlst.sh /ehx/vagrant-scripts/ehx_devl.py
cp /ehx/vagrant-scripts/weblogic/* /u01/app/domains/ehx_devl
STOP

echo "Add MOCK-HOST to /etc/hosts."
echo -e "IP      \tMOCK-HOST" >>/etc/hosts

echo "Set up Apache."
echo "  Copy vhost and cert files."
cp /ehx/weblogic/domains/ehx_devl/config/httpd/* /etc/httpd/conf.d
mkdir -p /etc/pki/tls/certs/ehx
cp /ehx/certs/* /etc/pki/tls/certs/ehx
echo "  Allow httpd to connect to localhost."
setsebool -P httpd_can_network_connect 1
echo "  Enable and start httpd service."
systemctl enable httpd
systemctl start httpd


echo "  Starting Weblogic Domain: ehx_devl    "
runuser -l vagrant << STOP 
cd /u01/app/domains/ehx_devl/
. ./startDomainDebug.sh
STOP

echo " Pausing script momentarily to let the domain fully startup before proceeding"  
sleep 4m

echo "Adding eHXSS groups and users to security realm: "
runuser -l vagrant << STOP 
cd /u01/app/oracle/weblogic/wlserver/server/bin/
source ./setWLSEnv.sh
java weblogic.WLST /ehx/vagrant-scripts/createEHXUsersGroups.py
STOP

echo "Congrats, you're ready to go."


