
#=======================================================================================
# eHXSS setting up users/groups - Workflow: 
#                - Start Admin Server
#                - Connect to Admin Server
#				 - Add new groups & users
#				 - Assign users to Groups
#                - Shutdown Admin Server
#=======================================================================================	
from weblogic.management.security.authentication import UserEditorMBean, GroupEditorMBean

print ' -----------------Connecting to Admin Server---------------------------- '
connect('weblogic', 'weblogic123', 't3://localhost:7001')

print '  '
authenticatorPath= '/SecurityConfiguration/ehx_devl/Realms/myrealm/AuthenticationProviders/DefaultAuthenticator'

print "Authenticator Path: " + authenticatorPath
cd (authenticatorPath)


print "Creating eHXSS Users (tester/user) . . ."
try:
	cmo.createUser('ehx-tester','ehx-tester','ehx-tester')
	cmo.createUser('ehx-user','ehx-user','ehx-user')
	print "-----Users created successfully!"
except: 
	print '********************* Something went wrong Creating the Users - Check to make sure they do not exist already *********************'
	print 'Error: ', sys.exc_info()[0], sys.exc_info()[1]
print '  '

print "Creating eHXSS specific Groups  . . ."
try:
	cmo.createGroup('eHXSS_Tester', 'eHXSS_Tester')
	cmo.createGroup('eHXSS_User', 'eHXSS_User')
	print '-----Groups created successfully!'
except: 
	
	print '********************* Something went wrong Creating the groups - Check to make sure they do not exist already *********************'
	print 'Error: ', sys.exc_info()[0], sys.exc_info()[1]
print '  '
print "Adding new eHXSS users to paired groups . . ."

try:
	cmo.addMemberToGroup('eHXSS_Tester','ehx-tester')
	cmo.addMemberToGroup('eHXSS_User','ehx-user')
	print '-----Users added to groups successfully!'
except: 
	print '********************* Something went wrong adding the users to the groups *********************'
	print 'Error: ', sys.exc_info()[0], sys.exc_info()[1]
print '  '

shutdown()


