package vler.exchange.va.gov.unit.tests;

import gov.va.ccd.components.impl.EncounterComponent;
import gov.va.ccd.components.impl.PlanOfCare;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;

import org.junit.Test;
import org.openhealthtools.mdht.uml.cda.Supply;
import org.openhealthtools.mdht.uml.cda.ccd.CCDFactory;
import org.openhealthtools.mdht.uml.cda.ccd.ContinuityOfCareDocument;
import org.openhealthtools.mdht.uml.cda.ccd.EncountersSection;
import org.openhealthtools.mdht.uml.cda.ccd.PlanOfCareSection;
import org.openhealthtools.mdht.uml.cda.util.CDAUtil;

import vler.exchange.va.gov.data.generation.Generators;
import vler.va.gov.unit.tests.AbstractTestRunner;

public class CreateSamples extends AbstractTestRunner {
	private void writeIt(final String fname, ContinuityOfCareDocument ccd) throws Exception {
		File outfile = new File(fname);
		FileOutputStream outs = new FileOutputStream(outfile);
		OutputStreamWriter ows = new OutputStreamWriter(outs, "UTF8");
		CDAUtil.save(ccd, ows);
		ows.flush();
		outs.flush();
		ows.close();
		outs.close();
	}

	@Test
	public void testCreateSupplies() throws Exception {
		ContinuityOfCareDocument ccd = (ContinuityOfCareDocument) Generators.createCCDDocument();
		Supply supply = Generators.createSupply();

		PlanOfCareSection pcs = CCDFactory.eINSTANCE.createPlanOfCareSection().init();
		pcs.addSupply(supply);
		ccd.addSection(pcs);
		writeIt("c:/test/testsupply.xml", ccd);
	}

	@Test
	public void testCreateObservations() throws Exception {
		ContinuityOfCareDocument ccd = (ContinuityOfCareDocument) Generators.createCCDDocument();
		PlanOfCareSection pcs = CCDFactory.eINSTANCE.createPlanOfCareSection().init();

		pcs.addObservation(Generators.createObservation());
		ccd.addSection(pcs);
		writeIt("c:/test/testobservation.xml", ccd);
	}

	@Test
	public void testEncompassingEncounter() throws Exception {
		ContinuityOfCareDocument ccd = (ContinuityOfCareDocument) Generators.createEncompassing();

		EncountersSection section = CCDFactory.eINSTANCE.createEncountersSection().init();
		ccd.addSection(section);

		section.addEncounter(Generators.createEncounter());

		final EncounterComponent encounter = new EncounterComponent(ccd);
		encounter.execute();
		writeIt("c:/test/testEncompassingEncounter.xml", ccd);
	}

	@Test
	public void testCreatePlanofCareDoc() throws Exception {
		ContinuityOfCareDocument ccd = (ContinuityOfCareDocument) Generators.createCCDDocument();
		PlanOfCareSection pcs = CCDFactory.eINSTANCE.createPlanOfCareSection().init();
		ccd.setId(Generators.createII("2.16.840.1.113883.4.349", "SAMPLEDOC"));
		pcs.addObservation(Generators.createObservation());
		pcs.addSupply(Generators.createSupply());
		pcs.addObservation(Generators.createObservation());
		pcs.addSupply(Generators.createSupply());
		pcs.addObservation(Generators.createObservation());
		pcs.addSupply(Generators.createSupply());
		pcs.addAct(Generators.createAct());
		pcs.addEncounter(Generators.createEncounter());
		pcs.addProcedure(Generators.createProcedure());
		pcs.addSubstanceAdministration(Generators.createSubstance());
		ccd.addSection(pcs);

		final PlanOfCare plansComponent = new PlanOfCare(ccd);
		plansComponent.execute();
		writeIt("c:/test/testplanofcare.xml", ccd);
	}
}
