package vler.exchange.va.gov.data.generation;

import java.math.BigDecimal;

import org.openhealthtools.mdht.uml.cda.CDAFactory;
import org.openhealthtools.mdht.uml.cda.SubstanceAdministration;
import org.openhealthtools.mdht.uml.cda.ccd.CCDFactory;
import org.openhealthtools.mdht.uml.cda.ccd.MedicationsSection;
import org.openhealthtools.mdht.uml.hl7.datatypes.CD;
import org.openhealthtools.mdht.uml.hl7.datatypes.CE;
import org.openhealthtools.mdht.uml.hl7.datatypes.DatatypesFactory;
import org.openhealthtools.mdht.uml.hl7.datatypes.ED;
import org.openhealthtools.mdht.uml.hl7.datatypes.II;
import org.openhealthtools.mdht.uml.hl7.datatypes.IVL_PQ;
import org.openhealthtools.mdht.uml.hl7.datatypes.PQ;
import org.openhealthtools.mdht.uml.hl7.datatypes.RTO_PQ_PQ;

/**
 * Generate Sample Medications section
 * 
 * @author Brad Messerle
 * 
 */
public class MedicationsSectionGenerator extends AbstractDataGenerator {

	public void createMedicationSection() {
		final MedicationsSection medSection = CCDFactory.eINSTANCE.createMedicationsSection().init();
		this.getDocument().addSection(medSection);
		this.createSubstanceAdminstration();
	}

	/**
	 * Add a new Substance Administration object
	 */
	public void createSubstanceAdminstration() {

		final SubstanceAdministration substanceAdmin = CDAFactory.eINSTANCE.createSubstanceAdministration();

		final II id = DatatypesFactory.eINSTANCE.createII();
		id.setRoot("2.16.840.1.113883.10.20.1.24");

		this.getDocument().getMedicationsSection().addSubstanceAdministration(substanceAdmin);

	}

	/**
	 * Add Free SIG Test
	 * 
	 * Data Item 8.01
	 * 
	 * @param freeText
	 */
	public void createFreeTextSig(final String freeText) {

		final SubstanceAdministration substanceAdministration = this.getDocument().getMedicationsSection()
				.getSubstanceAdministrations().get(0);
		final ED text = DatatypesFactory.eINSTANCE.createED(freeText);
		substanceAdministration.setText(text);

	}

	/**
	 * Add Route
	 * 
	 * Data Item 8.07
	 * 
	 * @param route
	 */
	public void createRoute(final String code, final String codeSystem, final String codeSystemName,
			final String displayName) {
		final SubstanceAdministration substanceAdministration = this.getDocument().getMedicationsSection()
				.getSubstanceAdministrations().get(0);
		final CE routeCode = DatatypesFactory.eINSTANCE.createCE(code, codeSystem, codeSystemName, displayName);
		substanceAdministration.setRouteCode(routeCode);
	}

	/**
	 * Add Dose
	 * 
	 * Data Item 8.08
	 */
	public void createDose(final BigDecimal quanity, final String unit) {
		final SubstanceAdministration substanceAdministration = this.getDocument().getMedicationsSection()
				.getSubstanceAdministrations().get(0);
		final IVL_PQ doseQuanity = DatatypesFactory.eINSTANCE.createIVL_PQ();
		doseQuanity.setValue(quanity);
		doseQuanity.setUnit(unit);
		substanceAdministration.setDoseQuantity(doseQuanity);
	}

	/**
	 * Add Site
	 * 
	 * Data Item 8.09
	 */
	public void createSite(final SubstanceAdministration subadm, final CD siteCode) {
		subadm.getApproachSiteCodes().add(siteCode);
	}

	/**
	 * Add Max Dose Quantity
	 * 
	 * Data Item 8.10
	 * 
	 */
	public void createMaxDoseQuanity(final double numeratorValue, final String numeratorSomething,
			final double denominatorValue, final String denominatorSomething) {
		final SubstanceAdministration substanceAdministration = this.getDocument().getMedicationsSection()
				.getSubstanceAdministrations().get(0);
		final RTO_PQ_PQ maxQuanity = DatatypesFactory.eINSTANCE.createRTO_PQ_PQ();
		final PQ numerator = DatatypesFactory.eINSTANCE.createPQ(numeratorValue, numeratorSomething);
		final PQ denominator = DatatypesFactory.eINSTANCE.createPQ(denominatorValue, denominatorSomething);

		maxQuanity.setDenominator(denominator);
		maxQuanity.setNumerator(numerator);
		substanceAdministration.setMaxDoseQuantity(maxQuanity);
	}

	/**
	 * Add Product Form
	 * 
	 * Data Item 8.11
	 */
	public void createProductForm(final String code, final String codeSystem, final String codeSystemName,
			final String displayName) {
		final SubstanceAdministration substanceAdministration = this.getDocument().getMedicationsSection()
				.getSubstanceAdministrations().get(0);
		final CE adminUnitCode = DatatypesFactory.eINSTANCE.createCE(code, codeSystem, codeSystemName, displayName);

		substanceAdministration.setAdministrationUnitCode(adminUnitCode);
	}

}
