<#ftl strip_whitespace=true>
<#include "../macros/allergyMacros.ftl">
<#include "../macros/defaultMacros.ftl">

<#if comments??>
<table id="_nbAllergyComments">
	<thead>
		<tr>
			<th>Comments</th>
		</tr>
	</thead>
	<tbody>
		<#if comments??>
			<#list comments as comment>
				<tr>
					<td>${comment}</td>
				</tr>
			</#list>
		</#if>
	</tbody>
</table>
</#if>
<table ID='_nbAllergyConsol' border='1' width='100%'>
	<thead>
		<tr>
			<th>Allergen</th>
			<th>Severity</th>
			<th>Reaction</th>
			<th>Reaction Severity</th>
			<th>Event Type</th>
			<th>Event Date</th>
			<th>Source</th>
		</tr>
	</thead>
	<tbody>
		<#if allergies??>
		<#list allergies as allergy>
		<tr>
			<#-- Allergen -->
			<td>
				<#if allergy.participants??>
					<#list allergy.participants as part>
						<#if part.playingEntity??>
							<@displayAllergenWithDefault part.playingEntity />
						</#if>
					</#list>
				<#else>
					--
				</#if>
			</td>
			<#-- Severity -->
			<td>
				<#if allergy.severity??>
					<@displaySeverity allergy.severity />
				<#else>
					--
				</#if>
			</td>
			<#-- Reaction -->
			<#-- value/@displayName  value/translation/@displayName  text/reference/@value-->		
			<td>
				<#if allergy.reactions??>
					<#list allergy.reactions as reaction>
						<@displayReactionWithDefault reaction /> <#if reaction_has_next>// </#if>
					</#list>
				<#else>
					--
				</#if>
			</td>
			<#-- Severity -->
			<td>
				<#if allergy.reactions??>
					<#list allergy.reactions as reaction>
						<@displaySeverity reaction.severity /> <#if reaction_has_next>// </#if>
					</#list>
				<#else>
					--
				</#if>
			</td>
			<#-- Event Type -->
			<td><@codeDispTextText allergy.eventType /></td>
			<#-- Event Date -->
			<td><@displayTime allergy /></td>
			<#-- Source -->
			<td>${allergy.source!"--"}</td>
		</tr>
		</#list>
		</#if>
	</tbody>
</table>