package gov.va.ccd.mapper;

import java.io.IOException;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;

public class TemplateMapper {
	private static TemplateMapper INSTANCE;
	private Configuration cfg = null;

	private TemplateMapper() throws IOException {
		cfg = new Configuration();

		cfg.setClassForTemplateLoading(TemplateMapper.class, "");

		cfg.setObjectWrapper(new DefaultObjectWrapper());

		cfg.setDefaultEncoding("UTF-8");

		cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);

		cfg.setIncompatibleImprovements(new Version(2, 3, 20)); // FreeMarker
																// 2.3.20
	}

	public synchronized static TemplateMapper getInstance() throws IOException {
		if (INSTANCE == null) {
			INSTANCE = new TemplateMapper();
		}

		return INSTANCE;
	}

	public Configuration getCfg() {
		return cfg;
	}
}
