package gov.va.ccd.comments.extractor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMap.Entry;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.openhealthtools.mdht.uml.cda.Section;

/**
 * Extract comments from a VA CCD Xml File
 * 
 * @author Brad Messerle
 * 
 */
public class VACommentsExtractor extends AbstractCommentsExtractor implements CommentsExtractor
{
	/** non va comments extractor **/
	private final NonVACommentsExtractor nonVaCommentsExtractor = new NonVACommentsExtractor();

	/**
	 * Comment String
	 */
	private String comment = "";

	public String getComment()
	{
		return comment;
	}

	public void setComment(String comment)
	{
		this.comment = comment;
	}

	@Override
	public <S extends Section> List<String> extractSectionComments(S section)
	{
		if(section != null && section.getText() != null)
		{
			List<String> comments = getTDFromTable(section.getText().getMixed());
			if(comments.size() > 1)
			{
				comments.remove(0);
			}
			if(StringUtils.isNotBlank(this.getComment()))
			{
				comments.add(this.getComment());
			}

			comments.addAll(nonVaCommentsExtractor.extractSectionComments(section));
			return comments;
		}
		return Collections.emptyList();
	}

	private static List<String> getTDFromTable(final FeatureMap map)
	{
		if(map != null)
		{
			for(Entry entry : map)
			{
				if(entry.getEStructuralFeature() instanceof EReference)
				{
					if("table".equalsIgnoreCase(entry.getEStructuralFeature().getName()))
					{
						// Found the first table. Lets build it and get out of
						// here.
						return getFromTD(((AnyType) entry.getValue()).getMixed());
					}
					else
					{
						// Didn't find the table. lets keep digging.
						return getTDFromTable(((AnyType) entry.getValue()).getMixed());
					}
				}
			}
		}
		return Collections.emptyList();
	}

	private static List<String> getFromTD(final FeatureMap map)
	{
		List<String> ret = new ArrayList<String>();

		for(Entry entry : map)
		{
			if(entry.getEStructuralFeature() instanceof EReference)
			{
				if("td".equalsIgnoreCase(entry.getEStructuralFeature().getName()))
				{
					// Found a value.
					ret.addAll(getValueFromTD(((AnyType) entry.getValue()).getMixed()));
				}
				else
				{
					// Didn't find the Column. lets keep digging.
					ret.addAll(getFromTD(((AnyType) entry.getValue()).getMixed()));
				}
			}
		}

		return ret;
	}

	private static List<String> getValueFromTD(final FeatureMap map)
	{
		List<String> ret = new ArrayList<String>();
		for(Entry entry : map)
		{
			if(!(entry.getEStructuralFeature() instanceof EReference))
			{
				String val = entry.getValue().toString();
				if(StringUtils.isNotBlank(val))
				{
					ret.add(val);
				}
			}
		}
		return ret;
	}
/*
	private static String rebuildItem(final FeatureMap map)
	{
		final StringBuilder sb = new StringBuilder();

		for(Entry entry : map)
		{
			sb.append(rebuildEntry(entry));
		}
		return sb.toString();
	}
*/ /*
	private static String rebuildEntry(final Entry entry)
	{
		StringBuilder sb = new StringBuilder();

		if(entry.getEStructuralFeature() instanceof EReference)
		{
			String tag = entry.getEStructuralFeature().getName();
			sb.append("<").append(tag).append(" ");
			AnyType any = (AnyType) entry.getValue();
			sb.append(recreateAttributes(any.getAnyAttribute()));
			sb.append(">");
			if(any.getMixed() != null)
			{
				sb.append(rebuildItem(any.getMixed()));
			}
			sb.append("</").append(tag).append(">");
		}
		else
		{
			if(entry.getValue() != null)
			{
				String value = StringUtils.trimToEmpty(entry.getValue().toString());
				if(StringUtils.isNotBlank(value))
				{
					sb.append(value);
				}
			}
			else
			{
				sb.append(">");
			}
		}

		return sb.toString();
	}
*/ /*
	private static String recreateAttributes(final FeatureMap anyAttribute)
	{
		final StringBuilder sb = new StringBuilder();
		for(Entry entry : anyAttribute)
		{
			sb.append(entry.getEStructuralFeature().getName()).append("=");
			sb.append("\"").append(entry.getValue().toString()).append("\"").append(" ");
		}

		return sb.toString();
	}
*/
}
