package gov.va.ccd.comments.extractor;

import gov.va.ccd.service.util.Utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.openhealthtools.mdht.uml.cda.Entry;
import org.openhealthtools.mdht.uml.cda.Section;
import org.openhealthtools.mdht.uml.hl7.datatypes.CD;
import org.openhealthtools.mdht.uml.hl7.datatypes.ED;

/**
 * Non VA CCD Comments Extractor
 * 
 * @author Brad Messerle
 * 
 */
public class NonVACommentsExtractor extends AbstractCommentsExtractor implements CommentsExtractor
{
	/** Comment Act Code **/
	private static final String COMMENT_CODE = "48767-8";

	@Override
	public <S extends Section> List<String> extractSectionComments(S section)
	{

		final List<String> comments = new ArrayList<String>();
		final StringBuilder comment = new StringBuilder();
		if(section == null)
		{
			return Collections.emptyList();
		}
		for(Entry entry : section.getEntries())
		{

			if(entry.getAct() != null)
			{

				final CD code = entry.getAct().getCode();
				if(code.getCode() != null && code.getCode().equalsIgnoreCase(COMMENT_CODE))
				{
					final ED text = entry.getAct().getText();
					if(text != null && text.getReference() != null)
					{
						String val = Utils.getReferenceValue(section.getText(), text.getReference().getValue());
						if(StringUtils.isNotBlank(val))
						{
							comment.append(val);
						}
					}
					else if(text != null && StringUtils.isNotEmpty(text.getText()))
					{
						comment.append(text.getText());
					}

					if(comment.length() > 0)
					{
						comments.add(comment.toString());
					}
				}

			}
		}

		return comments;
	}
}
