/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.soapui;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.OutgoingWssConfig;
import com.eviware.soapui.impl.wsdl.support.wss.DefaultWssContainer;
import com.eviware.soapui.impl.wsdl.support.wss.OutgoingWss;
import com.eviware.soapui.impl.wsdl.support.wss.WssCrypto;
import com.eviware.soapui.impl.wsdl.support.wss.WssEntry;
import com.eviware.soapui.impl.wsdl.support.wss.entries.AutomaticSAMLEntry;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Merlin;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 *
 * @author adambell
 */
public class CONNECTOutgoingWss extends OutgoingWss {

    public CONNECTOutgoingWss(OutgoingWss outgoing) {
        this(outgoing.getConfig(), (DefaultWssContainer)outgoing.getWssContainer());
    }
    
    public CONNECTOutgoingWss(OutgoingWssConfig config, DefaultWssContainer container) {
        super(config, container);
    }
    
    @Override
    public void processOutgoing(Document soapDocument, PropertyExpansionContext context) throws WSSecurityException {
        Element header = WSSecurityUtil.findWsseSecurityHeaderBlock(soapDocument, soapDocument.getDocumentElement(),
                false);

        while (header != null) {
            header.getParentNode().removeChild(header);
            header = WSSecurityUtil.findWsseSecurityHeaderBlock(soapDocument, soapDocument.getDocumentElement(), false);
        }

        WSSecHeader secHeader = new WSSecHeader();

        if (StringUtils.hasContent(getActor())) {
            secHeader.setActor(getActor());
        }

        secHeader.setMustUnderstand(getMustUnderstand());

        secHeader.insertSecurityHeader(soapDocument);

        String crypto = UISupport.prompt("Enter certificate filename", "CONNECT SAML parameters", (this.getWssContainer().getCryptoNames())[0]); 
        String issuer = UISupport.prompt("Enter Issuer", "CONNECT SAML parameters", "");
        String subjectName = UISupport.prompt("Enter Subject Name", "CONNECT SAML parameters", "");
        String subjectQualifier = UISupport.prompt("Enter Subject Qualifier", "CONNECT SAML parameters", "");
        String username;
        try {
            username = UISupport.prompt("Enter Certificate Alias", "CONNECT SAML parameters", (((KeyStore)((Merlin)this.getWssContainer().getCryptoByName(crypto, true).getCrypto()).getKeyStore()).aliases()).nextElement());
        } catch (KeyStoreException ex) {
            username = UISupport.prompt("Enter Certificate Alias", "CONNECT SAML parameters", "");
        }
        
        try {
            CONNECTSAMLEntry connectEntry = new CONNECTSAMLEntry(getWssContainer().getOutgoingWssAt(0), crypto, issuer, subjectName, subjectQualifier, username);
            connectEntry.process(secHeader, soapDocument, context);
        } 
        catch (Throwable e) {
            SoapUI.logError(e);
        }
    }
    
}
