package gov.va.soapui;

import com.eviware.soapui.actions.Prefs;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.plugins.auto.PluginPrefs;
import com.eviware.soapui.support.components.FileFormComponent;
import com.eviware.soapui.support.components.SimpleForm;
import com.eviware.soapui.support.types.StringToStringMap;

@PluginPrefs
public class HtmlViewerPrefs implements Prefs {
    private SimpleForm htmlForm;
    public static final String CCDA_STYLESHEET = "CCDA Stylesheet";
    public static final String C32_STYLESHEET = "C32 Stylesheet";
    @Override
    public SimpleForm getForm() {
        if (htmlForm == null) {
            htmlForm = new SimpleForm();
            htmlForm.append(CCDA_STYLESHEET, new FileFormComponent("Location of the stylesheet used in the XML to HTML transformation of CCDA documents."));
            htmlForm.append(C32_STYLESHEET, new FileFormComponent("Location of the stylesheet used in the XML to HTML transformation of CCDA documents."));  
        }
        return htmlForm;
    }

    @Override
    public void setFormValues(Settings settings) {
        htmlForm.setValues(getValues(settings));
    }

    @Override
    public void getFormValues(Settings settings) {
        StringToStringMap values = new StringToStringMap();
        htmlForm.getValues(values);
        storeValues(values, settings);
    }

    @Override
    public void storeValues(StringToStringMap values, Settings settings) {
        settings.setString(CDASettings.CCDA_STYLESHEET, values.get(CCDA_STYLESHEET));
        settings.setString(CDASettings.C32_STYLESHEET, values.get(C32_STYLESHEET));
    }

    @Override
    public StringToStringMap getValues(Settings settings) {
        StringToStringMap htmlValues = new StringToStringMap();
        htmlValues.put(CCDA_STYLESHEET, settings.getString(CDASettings.CCDA_STYLESHEET, ""));
        htmlValues.put(C32_STYLESHEET, settings.getString(CDASettings.C32_STYLESHEET, ""));
        return htmlValues;
    }

    @Override
    public String getTitle() {
        return "C32/CCDA Viewer Settings";
    }
}
