#!/bin/sh
#========================================================================#
# Purpose: This is the shell script to run the static code analyses      #
# of the adapter project using HPE fortify.                              #
#                                                                        #
# The fortify report is generated in the location, NHIN_adapter/target   #
# updates 
#         (1/2/2018):                                                    #
#         1) HPE Fortify version updated from 17.10 to 17.20             #
#            which is the VA enforced standards effective rom 12/29/2017 # 
#         (6/5/2017):                                                    #
#         1) HPE Fortify version updated from 16.20 to 17.10             #
#            which is the VA enforced standards                          #
#         2) scan is performed using java version = 1.8                  #
#            as mentioned by the environment varaibale,                  #
#            fortify.sca.source.version                                  # 
#                                                                        #
#========================================================================#
MVN_ARGS="-Dfortify.sca.buildId=Adapter"
FORTIFY_VERSION="17.20"

mvn clean install $MVN_ARGS

rc=$?

if [ $rc -eq 0 ]; then
  mvn $MVN_ARGS com.hpe.security.fortify.maven.plugin:sca-maven-plugin:$FORTIFY_VERSION:clean
  
  mvn $MVN_ARGS -Dfortify.sca.exclude="**/gov/va/das/datamanager/vistalinksetup/VistALinkSetup.java;**/gov/va/med/nhin/adapter/audit/BulkExportMain.java" -Dfortify.sca.source.version=1.8 com.hpe.security.fortify.maven.plugin:sca-maven-plugin:$FORTIFY_VERSION:translate
    
  mvn $MVN_ARGS -Dfortify.sca.Xmx=2048M com.hpe.security.fortify.maven.plugin:sca-maven-plugin:$FORTIFY_VERSION:scan 
fi

exit $rC

