set echo on
set feedback on
set serveroutput on
var start_date  varchar2(80);
var end_date    varchar2(80);
var sid         varchar2(10);
var host        varchar2(30);
var user        varchar2(30);


spool VitalsQualifier_Update_Script.log;

begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :start_date from dual;
  select instance_name into :sid from v$instance;
  select host_name into :host from v$instance;
  select user into :user from dual;

  dbms_output.put_line('Script executed on SID:  '||:sid);
  dbms_output.put_line('Script executed on host: '||:host);
  dbms_output.put_line('Script start date/time:  '||:start_date);
  dbms_output.put_line('Script executed by:      '||:user);
end;
/
SET DEFINE OFF;

-- create sequence
CREATE SEQUENCE ADAPTER.VITALS_QUALIFIER_ID_SEQ
  START WITH 1
  MAXVALUE 999999999999999999999999999
  MINVALUE 1
  NOCYCLE
  NOCACHE
  NOORDER;
  
-- create table
CREATE TABLE ADAPTER.VITALS_QUALIFIER (
  QUAL_ID    	NUMBER NOT NULL UNIQUE,
  ELEMENT		VARCHAR2(1)  NOT NULL,
  QUALIFIER		VARCHAR2(255) NOT NULL 
);

-- create pk  
CREATE UNIQUE INDEX ADAPTER.VITALS_QUALIFIER_PK ON ADAPTER.VITALS_QUALIFIER
(QUALIFIER)
TABLESPACE ADAPTER_INDEX01;

ALTER TABLE ADAPTER.VITALS_QUALIFIER ADD (
  CONSTRAINT VITALS_QUALIFIER_PK
  PRIMARY KEY
  (QUALIFIER)
  USING INDEX ADAPTER.VITALS_QUALIFIER_PK
  ENABLE VALIDATE);

-- autoincrement qual id on insertion
CREATE OR REPLACE TRIGGER ADAPTER.VITALS_QUALIFIER_ID_TRIG
BEFORE INSERT
ON ADAPTER.VITALS_QUALIFIER
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
BEGIN
  if :NEW.QUAL_ID is null then
    :NEW.QUAL_ID := VITALS_QUALIFIER_ID_SEQ.NEXTVAL;
  end if;
END VITALS_QUALIFIER_ID_TRIG;
/

-- force pk inserts to uppercase
CREATE OR REPLACE TRIGGER ADAPTER.VITALS_QUALIFIER_QUAL_TRIG
BEFORE INSERT
ON ADAPTER.VITALS_QUALIFIER
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
BEGIN
   :NEW.QUALIFIER := UPPER(:NEW.QUALIFIER);
END VITALS_QUALIFIER_QUAL_TRIG;
/

-- set user perms 
GRANT SELECT ON ADAPTER.VITALS_QUALIFIER_ID_SEQ TO ADAPTER_USER;
GRANT SELECT ON ADAPTER.VITALS_QUALIFIER TO ADAPTER_READ;
GRANT SELECT, UPDATE, INSERT, DELETE ON ADAPTER.VITALS_QUALIFIER TO ADAPTER_USER;

-- set synonyms
CREATE PUBLIC SYNONYM VITALS_QUALIFIER FOR ADAPTER.VITALS_QUALIFIER;
CREATE PUBLIC SYNONYM VITALS_QUALIFIER_ID_SEQ FOR ADAPTER.VITALS_QUALIFIER_ID_SEQ;

-- insert qualifer data into new table
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'ACTUAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'ADULT CUFF');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'AEROSOL/HUMIDIFIED MASK');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'AFTER EXERCISE');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'AMBU BAG (BAG VALVE MASK)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'ARTERIAL LINE');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'ASSISTED VENTILATOR');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'AT REST');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'AUSCULTATE');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'BED');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'BIPAP (BI-LEVEL POSITIVE AIRWAY PRESSURE)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'BIPAP-CPAP (BI-LEVEL POSITIVE AIRWAY PRESSURE-CONTINUOUS POSITIVE AIRWAY PRESSURE)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'CALCULATED');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'CHAIR');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'CONTROLLED VENTILATOR');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'CPAP (CONTINUOUS POSITIVE AIRWAY PRESSURE)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'CUFF-AUTOMATED (AUTOMATED CUFF)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'CUFF-MANUAL (MANUAL CUFF)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'DOPPLER');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'DRY');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'ESTIMATED');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'FACE TENT');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'INVASIVE');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'LARYNGEAL MASK AIRWAY');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'LEAD');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'LG ADULT CUFF');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'LIFT SCALE');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'LYING');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'MASK');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'MONITOR');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'MUSTACHE CANNULA');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'NASAL CANNULA');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'NON RE-BREATHER (NON REBREATHER)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'NON-INVASIVE (NONINVASIVE)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'PALPATED');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'PARTIAL RE-BREATHER (PARTIAL REBREATHER)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'PEDIATRIC CUFF');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'PENDANT CANNULA');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'RESERVOIR CANNULA');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'ROOM AIR');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'SEMIFOWLERS');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'SITTING');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'SM ADULT CUFF');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'SPONTANEOUS');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'STANDING');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'STANDING WEIGHT');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'STATED');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'THIGH CUFF');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'T-PIECE');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'TRACHEOSTOMY COLLAR');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'TRANSTRACHEAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'TRENDELENBURG');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'VENTILATOR');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'VENTURI MASK');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'WHEELCHAIR SCALE');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'WITH ACTIVITY');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'WITH AMBULATION');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'WITH CAST OR BRACE');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'WITH PROSTHESIS');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'WITHOUT PROSTHESIS');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'APICAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'AV FISTULA (ARTERIOVENOUS FISTULA)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'AXILLARY');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'BILATERAL PERIPHERALS');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'BRACHIAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'CAROTID');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'CORE');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'DORSALIS PEDIS');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'FEMORAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'L ARM (LEFT ARM)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'L LEG (LEFT LEG)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'LEFT');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'ORAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'PERIPHERAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'POPLITEAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'POSTERIOR TIBIAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'R ARM (RIGHT ARM)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'R LEG (RIGHT LEG)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'RADIAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'RECTAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'RIGHT');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'SKIN');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'TEMPORAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'TYMPANIC');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'ULNAR');

-- update codeset table
INSERT INTO ADAPTER.CODESETS (CODESET_ID, CODESET, LOOKUP_TABLE, KEY_FIELD) VALUES (35, 'QUALIFIER', 'VITALS_QUALIFIER', 'QUALIFIER');
DELETE FROM ADAPTER.CODESETS WHERE 
  (CODESET_ID=30 AND CODESET='M' AND LOOKUP_TABLE='TRANSLATIONS' AND KEY_FIELD='TARGET_CODE'); 
DELETE FROM ADAPTER.CODESETS WHERE 
  (CODESET_ID=31 AND CODESET='T' AND LOOKUP_TABLE='TRANSLATIONS' AND KEY_FIELD='TARGET_CODE');

-- remove qualifiers from translations table
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41209 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='ACTUAL' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='ACTUAL' AND 
	DISPLAY_NAME='ACTUAL';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41210 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='ADULT CUFF' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='ADULT CUFF' AND 
	DISPLAY_NAME='ADULT CUFF';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41211 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='AEROSOL/HUMIDIFIED MASK' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='AEROSOL/HUMIDIFIED MASK' AND 
	DISPLAY_NAME='AEROSOL/HUMIDIFIED MASK';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41212 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='AFTER EXERCISE' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='AFTER EXERCISE' AND 
	DISPLAY_NAME='AFTER EXERCISE';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41213 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='AMBU BAG (BAG VALVE MASK) ' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='AMBU BAG (BAG VALVE MASK) ' AND 
	DISPLAY_NAME='AMBU BAG (BAG VALVE MASK) ';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41214 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='APICAL' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='APICAL' AND 
	DISPLAY_NAME='APICAL';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41215 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='ARTERIAL LINE' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='ARTERIAL LINE' AND 
	DISPLAY_NAME='ARTERIAL LINE';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41216 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='ASSISTED VENTILATOR' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='ASSISTED VENTILATOR' AND 
	DISPLAY_NAME='ASSISTED VENTILATOR';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41217 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='AT REST' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='AT REST' AND 
	DISPLAY_NAME='AT REST';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41218 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='AUSCULTATE' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='AUSCULTATE' AND 
	DISPLAY_NAME='AUSCULTATE';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41219 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='AV FISTULA (ARTERIOVENOUS FISTULA)' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='AV FISTULA (ARTERIOVENOUS FISTULA)' AND 
	DISPLAY_NAME='AV FISTULA (ARTERIOVENOUS FISTULA)';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41220 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='AXILLARY' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='AXILLARY' AND 
	DISPLAY_NAME='AXILLARY';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41221 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='BED' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='BED' AND 
	DISPLAY_NAME='BED';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41222 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='BILATERAL PERIPHERALS' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='BILATERAL PERIPHERALS' AND 
	DISPLAY_NAME='BILATERAL PERIPHERALS';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41223 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='BIPAP (BI-LEVEL POSITIVE AIRWAY PRESSURE)' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='BIPAP (BI-LEVEL POSITIVE AIRWAY PRESSURE)' AND 
	DISPLAY_NAME='BIPAP (BI-LEVEL POSITIVE AIRWAY PRESSURE)';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41224 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='BIPAP-CPAP (BI-LEVEL POSITIVE AIRWAY PRESSURE-CONTINUOUS POSITIVE AIRWAY PRESSURE)' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='BIPAP-CPAP (BI-LEVEL POSITIVE AIRWAY PRESSURE-CONTINUOUS POSITIVE AIRWAY PRESSURE)' AND 
	DISPLAY_NAME='BIPAP-CPAP (BI-LEVEL POSITIVE AIRWAY PRESSURE-CONTINUOUS POSITIVE AIRWAY PRESSURE)';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41225 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='BRACHIAL' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='BRACHIAL' AND 
	DISPLAY_NAME='BRACHIAL';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41226 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='CALCULATED' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='CALCULATED' AND 
	DISPLAY_NAME='CALCULATED';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41227 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='CAROTID' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='CAROTID' AND 
	DISPLAY_NAME='CAROTID';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41228 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='CHAIR' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='CHAIR' AND 
	DISPLAY_NAME='CHAIR';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41229 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='CONTROLLED VENTILATOR' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='CONTROLLED VENTILATOR' AND 
	DISPLAY_NAME='CONTROLLED VENTILATOR';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41230 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='CORE' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='CORE' AND 
	DISPLAY_NAME='CORE';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41231 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='CPAP (CONTINUOUS POSITIVE AIRWAY PRESSURE)' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='CPAP (CONTINUOUS POSITIVE AIRWAY PRESSURE)' AND 
	DISPLAY_NAME='CPAP (CONTINUOUS POSITIVE AIRWAY PRESSURE)';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41232 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='CUFF-AUTOMATED (AUTOMATED CUFF)' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='CUFF-AUTOMATED (AUTOMATED CUFF)' AND 
	DISPLAY_NAME='CUFF-AUTOMATED (AUTOMATED CUFF)';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41233 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='CUFF-MANUAL (MANUAL CUFF)' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='CUFF-MANUAL (MANUAL CUFF)' AND 
	DISPLAY_NAME='CUFF-MANUAL (MANUAL CUFF)';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41234 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='DOPPLER' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='DOPPLER' AND 
	DISPLAY_NAME='DOPPLER';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41235 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='DORSALIS PEDIS' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='DORSALIS PEDIS' AND 
	DISPLAY_NAME='DORSALIS PEDIS';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41236 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='DRY' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='DRY' AND 
	DISPLAY_NAME='DRY';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41237 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='ESTIMATED' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='ESTIMATED' AND 
	DISPLAY_NAME='ESTIMATED';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41238 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='FACE TENT' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='FACE TENT' AND 
	DISPLAY_NAME='FACE TENT';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41239 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='FEMORAL' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='FEMORAL' AND 
	DISPLAY_NAME='FEMORAL';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41240 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='INVASIVE' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='INVASIVE' AND 
	DISPLAY_NAME='INVASIVE';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41241 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='L ARM (LEFT ARM)' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='L ARM (LEFT ARM)' AND 
	DISPLAY_NAME='L ARM (LEFT ARM)';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41242 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='L LEG (LEFT LEG)' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='L LEG (LEFT LEG)' AND 
	DISPLAY_NAME='L LEG (LEFT LEG)';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41243 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='LARYNGEAL MASK AIRWAY' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='LARYNGEAL MASK AIRWAY' AND 
	DISPLAY_NAME='LARYNGEAL MASK AIRWAY';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41244 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='LEAD' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='LEAD' AND 
	DISPLAY_NAME='LEAD';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41245 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='LEFT' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='LEFT' AND 
	DISPLAY_NAME='LEFT';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41246 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='LG ADULT CUFF' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='LG ADULT CUFF' AND 
	DISPLAY_NAME='LG ADULT CUFF';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41247 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='LIFT SCALE' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='LIFT SCALE' AND 
	DISPLAY_NAME='LIFT SCALE';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41248 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='LYING' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='LYING' AND 
	DISPLAY_NAME='LYING';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41249 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='MASK' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='MASK' AND 
	DISPLAY_NAME='MASK';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41250 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='MONITOR' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='MONITOR' AND 
	DISPLAY_NAME='MONITOR';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41251 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='MUSTACHE CANNULA' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='MUSTACHE CANNULA' AND 
	DISPLAY_NAME='MUSTACHE CANNULA';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41252 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='NASAL CANNULA' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='NASAL CANNULA' AND 
	DISPLAY_NAME='NASAL CANNULA';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41253 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='NON RE-BREATHER (NON REBREATHER)' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='NON RE-BREATHER (NON REBREATHER)' AND 
	DISPLAY_NAME='NON RE-BREATHER (NON REBREATHER)';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41254 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='NON-INVASIVE (NONINVASIVE)' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='NON-INVASIVE (NONINVASIVE)' AND 
	DISPLAY_NAME='NON-INVASIVE (NONINVASIVE)';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41255 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='ORAL' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='ORAL' AND 
	DISPLAY_NAME='ORAL';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41256 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='PALPATED' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='PALPATED' AND 
	DISPLAY_NAME='PALPATED';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41257 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='PARTIAL RE-BREATHER (PARTIAL REBREATHER)' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='PARTIAL RE-BREATHER (PARTIAL REBREATHER)' AND 
	DISPLAY_NAME='PARTIAL RE-BREATHER (PARTIAL REBREATHER)';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41258 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='PEDIATRIC CUFF' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='PEDIATRIC CUFF' AND 
	DISPLAY_NAME='PEDIATRIC CUFF';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41259 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='PENDANT CANNULA' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='PENDANT CANNULA' AND 
	DISPLAY_NAME='PENDANT CANNULA';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41260 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='PERIPHERAL' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='PERIPHERAL' AND 
	DISPLAY_NAME='PERIPHERAL';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41261 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='POPLITEAL' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='POPLITEAL' AND 
	DISPLAY_NAME='POPLITEAL';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41262 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='POSTERIOR TIBIAL' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='POSTERIOR TIBIAL' AND 
	DISPLAY_NAME='POSTERIOR TIBIAL';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41263 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='R ARM (RIGHT ARM)' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='R ARM (RIGHT ARM)' AND 
	DISPLAY_NAME='R ARM (RIGHT ARM)';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41264 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='R LEG (RIGHT LEG)' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='R LEG (RIGHT LEG)' AND 
	DISPLAY_NAME='R LEG (RIGHT LEG)';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41265 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='RADIAL' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='RADIAL' AND 
	DISPLAY_NAME='RADIAL';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41266 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='RECTAL' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='RECTAL' AND 
	DISPLAY_NAME='RECTAL';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41267 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='RESERVOIR CANNULA' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='RESERVOIR CANNULA' AND 
	DISPLAY_NAME='RESERVOIR CANNULA';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41268 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='RIGHT' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='RIGHT' AND 
	DISPLAY_NAME='RIGHT';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41269 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='ROOM AIR' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='ROOM AIR' AND 
	DISPLAY_NAME='ROOM AIR';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41270 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='SEMIFOWLERS' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='SEMIFOWLERS' AND 
	DISPLAY_NAME='SEMIFOWLERS';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41271 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='SITTING' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='SITTING' AND 
	DISPLAY_NAME='SITTING';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41272 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='SKIN' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='SKIN' AND 
	DISPLAY_NAME='SKIN';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41273 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='SM ADULT CUFF' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='SM ADULT CUFF' AND 
	DISPLAY_NAME='SM ADULT CUFF';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41274 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='SPONTANEOUS' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='SPONTANEOUS' AND 
	DISPLAY_NAME='SPONTANEOUS';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41275 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='STANDING' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='STANDING' AND 
	DISPLAY_NAME='STANDING';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41276 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='STANDING WEIGHT' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='STANDING WEIGHT' AND 
	DISPLAY_NAME='STANDING WEIGHT';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41277 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='STATED' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='STATED' AND 
	DISPLAY_NAME='STATED';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41278 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='TEMPORAL' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='TEMPORAL' AND 
	DISPLAY_NAME='TEMPORAL';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41279 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='THIGH CUFF' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='THIGH CUFF' AND 
	DISPLAY_NAME='THIGH CUFF';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41280 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='T-PIECE' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='T-PIECE' AND 
	DISPLAY_NAME='T-PIECE';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41281 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='TRACHEOSTOMY COLLAR' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='TRACHEOSTOMY COLLAR' AND 
	DISPLAY_NAME='TRACHEOSTOMY COLLAR';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41282 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='TRANSTRACHEAL' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='TRANSTRACHEAL' AND 
	DISPLAY_NAME='TRANSTRACHEAL';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41283 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='TRENDELENBURG' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='TRENDELENBURG' AND 
	DISPLAY_NAME='TRENDELENBURG';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41284 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='TYMPANIC' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='TYMPANIC' AND 
	DISPLAY_NAME='TYMPANIC';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41285 AND 
	SOURCE_CODESET='T' AND 
	SOURCE_CODE='ULNAR' AND 
	TARGET_CODESET='T' AND 
	TARGET_CODE='ULNAR' AND 
	DISPLAY_NAME='ULNAR';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41286 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='VENTILATOR' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='VENTILATOR' AND 
	DISPLAY_NAME='VENTILATOR';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41287 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='VENTURI MASK' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='VENTURI MASK' AND 
	DISPLAY_NAME='VENTURI MASK';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41288 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='WHEELCHAIR SCALE' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='WHEELCHAIR SCALE' AND 
	DISPLAY_NAME='WHEELCHAIR SCALE';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41289 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='WITH ACTIVITY' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='WITH ACTIVITY' AND 
	DISPLAY_NAME='WITH ACTIVITY';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41290 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='WITH AMBULATION' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='WITH AMBULATION' AND 
	DISPLAY_NAME='WITH AMBULATION';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41291 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='WITH CAST OR BRACE' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='WITH CAST OR BRACE' AND 
	DISPLAY_NAME='WITH CAST OR BRACE';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41292 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='WITH PROSTHESIS' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='WITH PROSTHESIS' AND 
	DISPLAY_NAME='WITH PROSTHESIS';
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	TRANSLATION_ID=41293 AND 
	SOURCE_CODESET='M' AND 
	SOURCE_CODE='WITHOUT PROSTHESIS' AND 
	TARGET_CODESET='M' AND 
	TARGET_CODE='WITHOUT PROSTHESIS' AND 
	DISPLAY_NAME='WITHOUT PROSTHESIS';

commit;

Set Define on;

Begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :end_date from dual;
  dbms_output.put_line('Script end date/time:    '||:end_date);
  dbms_output.put_line('Script executed in '||(to_date(:end_date, 'mm_dd_yyyy hh24:mi:ss') - to_date(:start_date, 'mm-dd-yyyy hh24:mi:ss')) *24*60*60||' seconds');
end;
/

Spool off;
