set echo on
set feedback on
set serveroutput on
var start_date  varchar2(80);
var end_date    varchar2(80);
var sid         varchar2(10);
var host        varchar2(30);
var user        varchar2(30);


spool VitalsQualifier_Update_Script.log;

begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :start_date from dual;
  select instance_name into :sid from v$instance;
  select host_name into :host from v$instance;
  select user into :user from dual;

  dbms_output.put_line('Script executed on SID:  '||:sid);
  dbms_output.put_line('Script executed on host: '||:host);
  dbms_output.put_line('Script start date/time:  '||:start_date);
  dbms_output.put_line('Script executed by:      '||:user);
end;
/
SET DEFINE OFF;

DROP PUBLIC SYNONYM VITALS_QUALIFIER;
DROP PUBLIC SYNONYM VITALS_QUALIFIER_ID_SEQ;

DROP TABLE ADAPTER.VITALS_QUALIFIER CASCADE CONSTRAINTS;

DROP SEQUENCE ADAPTER.VITALS_QUALIFIER_ID_SEQ;

-- reinsert qualifiers back into translations
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41209, 'M', 'ACTUAL', 'M', 'ACTUAL', 'ACTUAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41210, 'M', 'ADULT CUFF', 'M', 'ADULT CUFF', 'ADULT CUFF');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41211, 'M', 'AEROSOL/HUMIDIFIED MASK', 'M', 'AEROSOL/HUMIDIFIED MASK', 'AEROSOL/HUMIDIFIED MASK');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41212, 'M', 'AFTER EXERCISE', 'M', 'AFTER EXERCISE', 'AFTER EXERCISE');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41213, 'M', 'AMBU BAG (BAG VALVE MASK) ', 'M', 'AMBU BAG (BAG VALVE MASK) ', 'AMBU BAG (BAG VALVE MASK) ');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41214, 'T', 'APICAL', 'T', 'APICAL', 'APICAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41215, 'M', 'ARTERIAL LINE', 'M', 'ARTERIAL LINE', 'ARTERIAL LINE');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41216, 'M', 'ASSISTED VENTILATOR', 'M', 'ASSISTED VENTILATOR', 'ASSISTED VENTILATOR');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41217, 'M', 'AT REST', 'M', 'AT REST', 'AT REST');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41218, 'M', 'AUSCULTATE', 'M', 'AUSCULTATE', 'AUSCULTATE');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41219, 'T', 'AV FISTULA (ARTERIOVENOUS FISTULA)', 'T', 'AV FISTULA (ARTERIOVENOUS FISTULA)', 'AV FISTULA (ARTERIOVENOUS FISTULA)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41220, 'T', 'AXILLARY', 'T', 'AXILLARY', 'AXILLARY');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41221, 'M', 'BED', 'M', 'BED', 'BED');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41222, 'T', 'BILATERAL PERIPHERALS', 'T', 'BILATERAL PERIPHERALS', 'BILATERAL PERIPHERALS');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41223, 'M', 'BIPAP (BI-LEVEL POSITIVE AIRWAY PRESSURE)', 'M', 'BIPAP (BI-LEVEL POSITIVE AIRWAY PRESSURE)', 'BIPAP (BI-LEVEL POSITIVE AIRWAY PRESSURE)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41224, 'M', 'BIPAP-CPAP (BI-LEVEL POSITIVE AIRWAY PRESSURE-CONTINUOUS POSITIVE AIRWAY PRESSURE)', 'M', 'BIPAP-CPAP (BI-LEVEL POSITIVE AIRWAY PRESSURE-CONTINUOUS POSITIVE AIRWAY PRESSURE)', 'BIPAP-CPAP (BI-LEVEL POSITIVE AIRWAY PRESSURE-CONTINUOUS POSITIVE AIRWAY PRESSURE)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41225, 'T', 'BRACHIAL', 'T', 'BRACHIAL', 'BRACHIAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41226, 'M', 'CALCULATED', 'M', 'CALCULATED', 'CALCULATED');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41227, 'T', 'CAROTID', 'T', 'CAROTID', 'CAROTID');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41228, 'M', 'CHAIR', 'M', 'CHAIR', 'CHAIR');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41229, 'M', 'CONTROLLED VENTILATOR', 'M', 'CONTROLLED VENTILATOR', 'CONTROLLED VENTILATOR');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41230, 'T', 'CORE', 'T', 'CORE', 'CORE');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41231, 'M', 'CPAP (CONTINUOUS POSITIVE AIRWAY PRESSURE)', 'M', 'CPAP (CONTINUOUS POSITIVE AIRWAY PRESSURE)', 'CPAP (CONTINUOUS POSITIVE AIRWAY PRESSURE)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41232, 'M', 'CUFF-AUTOMATED (AUTOMATED CUFF)', 'M', 'CUFF-AUTOMATED (AUTOMATED CUFF)', 'CUFF-AUTOMATED (AUTOMATED CUFF)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41233, 'M', 'CUFF-MANUAL (MANUAL CUFF)', 'M', 'CUFF-MANUAL (MANUAL CUFF)', 'CUFF-MANUAL (MANUAL CUFF)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41234, 'M', 'DOPPLER', 'M', 'DOPPLER', 'DOPPLER');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41235, 'T', 'DORSALIS PEDIS', 'T', 'DORSALIS PEDIS', 'DORSALIS PEDIS');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41236, 'M', 'DRY', 'M', 'DRY', 'DRY');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41237, 'M', 'ESTIMATED', 'M', 'ESTIMATED', 'ESTIMATED');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41238, 'M', 'FACE TENT', 'M', 'FACE TENT', 'FACE TENT');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41239, 'T', 'FEMORAL', 'T', 'FEMORAL', 'FEMORAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41240, 'M', 'INVASIVE', 'M', 'INVASIVE', 'INVASIVE');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41241, 'T', 'L ARM (LEFT ARM)', 'T', 'L ARM (LEFT ARM)', 'L ARM (LEFT ARM)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41242, 'T', 'L LEG (LEFT LEG)', 'T', 'L LEG (LEFT LEG)', 'L LEG (LEFT LEG)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41243, 'M', 'LARYNGEAL MASK AIRWAY', 'M', 'LARYNGEAL MASK AIRWAY', 'LARYNGEAL MASK AIRWAY');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41244, 'M', 'LEAD', 'M', 'LEAD', 'LEAD');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41245, 'T', 'LEFT', 'T', 'LEFT', 'LEFT');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41246, 'M', 'LG ADULT CUFF', 'M', 'LG ADULT CUFF', 'LG ADULT CUFF');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41247, 'M', 'LIFT SCALE', 'M', 'LIFT SCALE', 'LIFT SCALE');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41248, 'M', 'LYING', 'M', 'LYING', 'LYING');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41249, 'M', 'MASK', 'M', 'MASK', 'MASK');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41250, 'M', 'MONITOR', 'M', 'MONITOR', 'MONITOR');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41251, 'M', 'MUSTACHE CANNULA', 'M', 'MUSTACHE CANNULA', 'MUSTACHE CANNULA');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41252, 'M', 'NASAL CANNULA', 'M', 'NASAL CANNULA', 'NASAL CANNULA');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41253, 'M', 'NON RE-BREATHER (NON REBREATHER)', 'M', 'NON RE-BREATHER (NON REBREATHER)', 'NON RE-BREATHER (NON REBREATHER)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41254, 'M', 'NON-INVASIVE (NONINVASIVE)', 'M', 'NON-INVASIVE (NONINVASIVE)', 'NON-INVASIVE (NONINVASIVE)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41255, 'T', 'ORAL', 'T', 'ORAL', 'ORAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41256, 'M', 'PALPATED', 'M', 'PALPATED', 'PALPATED');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41257, 'M', 'PARTIAL RE-BREATHER (PARTIAL REBREATHER)', 'M', 'PARTIAL RE-BREATHER (PARTIAL REBREATHER)', 'PARTIAL RE-BREATHER (PARTIAL REBREATHER)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41258, 'M', 'PEDIATRIC CUFF', 'M', 'PEDIATRIC CUFF', 'PEDIATRIC CUFF');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41259, 'M', 'PENDANT CANNULA', 'M', 'PENDANT CANNULA', 'PENDANT CANNULA');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41260, 'T', 'PERIPHERAL', 'T', 'PERIPHERAL', 'PERIPHERAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41261, 'T', 'POPLITEAL', 'T', 'POPLITEAL', 'POPLITEAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41262, 'T', 'POSTERIOR TIBIAL', 'T', 'POSTERIOR TIBIAL', 'POSTERIOR TIBIAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41263, 'T', 'R ARM (RIGHT ARM)', 'T', 'R ARM (RIGHT ARM)', 'R ARM (RIGHT ARM)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41264, 'T', 'R LEG (RIGHT LEG)', 'T', 'R LEG (RIGHT LEG)', 'R LEG (RIGHT LEG)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41265, 'T', 'RADIAL', 'T', 'RADIAL', 'RADIAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41266, 'T', 'RECTAL', 'T', 'RECTAL', 'RECTAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41267, 'M', 'RESERVOIR CANNULA', 'M', 'RESERVOIR CANNULA', 'RESERVOIR CANNULA');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41268, 'T', 'RIGHT', 'T', 'RIGHT', 'RIGHT');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41269, 'M', 'ROOM AIR', 'M', 'ROOM AIR', 'ROOM AIR');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41270, 'M', 'SEMIFOWLERS', 'M', 'SEMIFOWLERS', 'SEMIFOWLERS');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41271, 'M', 'SITTING', 'M', 'SITTING', 'SITTING');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41272, 'T', 'SKIN', 'T', 'SKIN', 'SKIN');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41273, 'M', 'SM ADULT CUFF', 'M', 'SM ADULT CUFF', 'SM ADULT CUFF');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41274, 'M', 'SPONTANEOUS', 'M', 'SPONTANEOUS', 'SPONTANEOUS');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41275, 'M', 'STANDING', 'M', 'STANDING', 'STANDING');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41276, 'M', 'STANDING WEIGHT', 'M', 'STANDING WEIGHT', 'STANDING WEIGHT');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41277, 'M', 'STATED', 'M', 'STATED', 'STATED');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41278, 'T', 'TEMPORAL', 'T', 'TEMPORAL', 'TEMPORAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41279, 'M', 'THIGH CUFF', 'M', 'THIGH CUFF', 'THIGH CUFF');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41280, 'M', 'T-PIECE', 'M', 'T-PIECE', 'T-PIECE');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41281, 'M', 'TRACHEOSTOMY COLLAR', 'M', 'TRACHEOSTOMY COLLAR', 'TRACHEOSTOMY COLLAR');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41282, 'M', 'TRANSTRACHEAL', 'M', 'TRANSTRACHEAL', 'TRANSTRACHEAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41283, 'M', 'TRENDELENBURG', 'M', 'TRENDELENBURG', 'TRENDELENBURG');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41284, 'T', 'TYMPANIC', 'T', 'TYMPANIC', 'TYMPANIC');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41285, 'T', 'ULNAR', 'T', 'ULNAR', 'ULNAR');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41286, 'M', 'VENTILATOR', 'M', 'VENTILATOR', 'VENTILATOR');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41287, 'M', 'VENTURI MASK', 'M', 'VENTURI MASK', 'VENTURI MASK');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41288, 'M', 'WHEELCHAIR SCALE', 'M', 'WHEELCHAIR SCALE', 'WHEELCHAIR SCALE');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41289, 'M', 'WITH ACTIVITY', 'M', 'WITH ACTIVITY', 'WITH ACTIVITY');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41290, 'M', 'WITH AMBULATION', 'M', 'WITH AMBULATION', 'WITH AMBULATION');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41291, 'M', 'WITH CAST OR BRACE', 'M', 'WITH CAST OR BRACE', 'WITH CAST OR BRACE');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41292, 'M', 'WITH PROSTHESIS', 'M', 'WITH PROSTHESIS', 'WITH PROSTHESIS');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41293, 'M', 'WITHOUT PROSTHESIS', 'M', 'WITHOUT PROSTHESIS', 'WITHOUT PROSTHESIS');
	
-- revert codesets table
DELETE FROM ADAPTER.CODESETS WHERE
	CODESET_ID=35 AND CODESET='QUALIFIER' AND LOOKUP_TABLE='VITALS_QUALIFIER' AND KEY_FIELD='QUALIFIER' ;
INSERT INTO ADAPTER.CODESETS (CODESET_ID, CODESET, LOOKUP_TABLE, KEY_FIELD) 
	VALUES (30, 'M', 'TRANSLATIONS', 'TARGET_CODE');
INSERT INTO ADAPTER.CODESETS (CODESET_ID, CODESET, LOOKUP_TABLE, KEY_FIELD) 
	VALUES (31, 'T', 'TRANSLATIONS', 'TARGET_CODE');
	
commit;

Set Define on;

Begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :end_date from dual;
  dbms_output.put_line('Script end date/time:    '||:end_date);
  dbms_output.put_line('Script executed in '||(to_date(:end_date, 'mm_dd_yyyy hh24:mi:ss') - to_date(:start_date, 'mm-dd-yyyy hh24:mi:ss')) *24*60*60||' seconds');
end;
/

Spool off;

