CREATE TABLE ADAPTER.VA_TYPES
(
  VA_TYPE_ID     NUMBER                         NOT NULL,
  LOINC_CODE     VARCHAR2(10 BYTE),
  LOINC_DESC     VARCHAR2(255 BYTE),
  DOC_SPEC_TYPE  VARCHAR2(20 BYTE),
  QUERYNAME      VARCHAR2(30 BYTE)
);


CREATE UNIQUE INDEX ADAPTER.VA_TYPES_PK ON ADAPTER.VA_TYPES
(VA_TYPE_ID);

CREATE OR REPLACE TRIGGER ADAPTER.VA_TYPES_TRG
BEFORE INSERT
ON ADAPTER.VA_TYPES
FOR EACH ROW
BEGIN
    if :new.VA_TYPE_ID is null then
        :new.VA_TYPE_ID := ADAPTER.VA_TYPES_SEQ.nextval;
    end if;
END VA_TYPES_TRG;
/



ALTER TABLE ADAPTER.VA_TYPES ADD (
  CONSTRAINT VA_TYPES_PK
  PRIMARY KEY
  (VA_TYPE_ID)
  USING INDEX ADAPTER.VA_TYPES_PK
  ENABLE VALIDATE);
