CREATE TABLE ADAPTER.SUBSCRIPTIONS
(
  SUBSCRIPTION_ID    NUMBER                     NOT NULL,
  RESOURCE_ID        VARCHAR2(36 BYTE),
  STATUS             VARCHAR2(255 BYTE),
  CRITERIA           VARCHAR2(255 BYTE),
  CHANNEL            VARCHAR2(255 BYTE),
  USER_ID            VARCHAR2(255 BYTE),
  USER_NAME          VARCHAR2(255 BYTE),
  ORGANIZATION_ID    VARCHAR2(255 BYTE),
  ORGANIZATION_NAME  VARCHAR2(255 BYTE),
  PURPOSE_OF_USE     VARCHAR2(255 BYTE),
  CREATED_TIME       TIMESTAMP(6) WITH LOCAL TIME ZONE DEFAULT sysdate,
  LAST_UPDATED_TIME  TIMESTAMP(6) WITH LOCAL TIME ZONE,
  FHIR_RESOURCE      BLOB
);

COMMENT ON TABLE ADAPTER.SUBSCRIPTIONS IS 'This is table for Async Subscription service.';


CREATE UNIQUE INDEX ADAPTER.SUBSCRIPTIONS_PK ON ADAPTER.SUBSCRIPTIONS
(SUBSCRIPTION_ID);

CREATE UNIQUE INDEX ADAPTER.SUBSCRIPTIONS_UK1 ON ADAPTER.SUBSCRIPTIONS
(RESOURCE_ID);

CREATE OR REPLACE TRIGGER ADAPTER.SUBSCRIPTION_ID_TRG
BEFORE INSERT
ON ADAPTER.SUBSCRIPTIONS
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
begin
  if :NEW.SUBSCRIPTION_ID is null then
    :NEW.SUBSCRIPTION_ID := SUBSCRIPTION_ID_SEQ.NEXTVAL;
  end if;
end;
/


ALTER TABLE ADAPTER.SUBSCRIPTIONS ADD (
  CONSTRAINT SUBSCRIPTIONS_PK
  PRIMARY KEY
  (SUBSCRIPTION_ID)
  USING INDEX ADAPTER.SUBSCRIPTIONS_PK
  ENABLE VALIDATE);
