CREATE TABLE ADAPTER.SENSITIVE_INFO
(
  INFO_ID     NUMBER                            NOT NULL,
  LOCATION    VARCHAR2(255 BYTE),
  SENS_VALUE  VARCHAR2(255 BYTE)
);


CREATE UNIQUE INDEX ADAPTER.SENSITIVE_INFO_PK ON ADAPTER.SENSITIVE_INFO
(INFO_ID);

CREATE OR REPLACE TRIGGER ADAPTER.SENSITIVE_INFO_TRG
BEFORE INSERT
ON ADAPTER.SENSITIVE_INFO
FOR EACH ROW
BEGIN
    :new.INFO_ID := ADAPTER.SENSITIVE_INFO_SEQ.nextval;
END SENSITIVE_INFO_TRG;
/


ALTER TABLE ADAPTER.SENSITIVE_INFO ADD (
  CONSTRAINT SENSITIVE_INFO_PK
  PRIMARY KEY
  (INFO_ID)
  USING INDEX ADAPTER.SENSITIVE_INFO_PK
  ENABLE VALIDATE);
