CREATE TABLE ADAPTER.SAB
(
  SAB_ID          NUMBER                        NOT NULL,
  TRANSLATION_ID  NUMBER                        NOT NULL,
  SAB_TEXT        VARCHAR2(255 BYTE)
);


CREATE UNIQUE INDEX ADAPTER.SAB_PK ON ADAPTER.SAB
(SAB_ID);

CREATE OR REPLACE TRIGGER ADAPTER.SAB_TRG
BEFORE INSERT
ON ADAPTER.SAB
FOR EACH ROW
BEGIN
    if :new.SAB_ID is null then
        :new.SAB_ID := ADAPTER.SAB_SEQ.nextval;
    end if;
END SAB_TRG;
/


ALTER TABLE ADAPTER.SAB ADD (
  CONSTRAINT SAB_PK
  PRIMARY KEY
  (SAB_ID)
  USING INDEX ADAPTER.SAB_PK
  ENABLE VALIDATE);
