CREATE TABLE ADAPTER.REQUEST_LOG
(
  ID          NUMBER                            NOT NULL,
  HCID        VARCHAR2(255 BYTE),
  PID         VARCHAR2(255 BYTE),
  START_TIME  TIMESTAMP(6),
  STOP_TIME   TIMESTAMP(6),
  UUID        VARCHAR2(100 BYTE),
  ACTION      VARCHAR2(255 BYTE),
  STATUS      VARCHAR2(255 BYTE),
  UNAME       VARCHAR2(255 BYTE)
);


CREATE UNIQUE INDEX ADAPTER.REQUEST_LOG_PK ON ADAPTER.REQUEST_LOG
(ID);

CREATE OR REPLACE TRIGGER ADAPTER.REQUEST_LOG_TRG
BEFORE INSERT
ON ADAPTER.REQUEST_LOG
FOR EACH ROW
BEGIN
    if :new.ID is null then
        :new.ID := ADAPTER.REQUEST_LOG_SEQ.nextval;
    end if;
END REQUEST_LOG_TRG;
/


ALTER TABLE ADAPTER.REQUEST_LOG ADD (
  CONSTRAINT REQUEST_LOG_PK
  PRIMARY KEY
  (ID)
  USING INDEX ADAPTER.REQUEST_LOG_PK
  ENABLE VALIDATE);
