CREATE TABLE ADAPTER.DQ_TRANSMISSION_LOG
(
  DQ_TRANSMISSION_ID  NUMBER                    NOT NULL,
  BATCH_ID            VARCHAR2(255 BYTE),
  EVENT_TYPE          VARCHAR2(255 BYTE),
  START_TIME          TIMESTAMP(6)              NOT NULL,
  END_TIME            TIMESTAMP(6),
  HOSTNAME            VARCHAR2(255 BYTE),
  LOCAL_DOC_ID        VARCHAR2(255 BYTE),
  FILENAME            VARCHAR2(255 BYTE),
  FILETYPE            VARCHAR2(255 BYTE),
  FILESIZE            NUMBER,
  DESTINATION         VARCHAR2(255 BYTE),
  STATUS              VARCHAR2(255 BYTE),
  REMOTE_DOC_ID       VARCHAR2(255 BYTE),
  ERROR               VARCHAR2(3000 BYTE)
);


CREATE UNIQUE INDEX ADAPTER.DQ_TRANSMISSION_LOG_PK ON ADAPTER.DQ_TRANSMISSION_LOG
(DQ_TRANSMISSION_ID);

CREATE INDEX ADAPTER.NDX_DQTRANSLOG_FILENAME ON ADAPTER.DQ_TRANSMISSION_LOG
(FILENAME);

CREATE INDEX ADAPTER.NDX_DQTRANSLOG_LOCAL_DOC_ID ON ADAPTER.DQ_TRANSMISSION_LOG
(LOCAL_DOC_ID);

CREATE INDEX ADAPTER.NDX_DQTRANSLOG_REMOTE_DOC_ID ON ADAPTER.DQ_TRANSMISSION_LOG
(REMOTE_DOC_ID);

CREATE INDEX ADAPTER.NDX_DQTRANSLOG_START_TIME ON ADAPTER.DQ_TRANSMISSION_LOG
(START_TIME);

CREATE OR REPLACE TRIGGER ADAPTER.DQ_TRANSMISSION_ID_TRG
BEFORE INSERT
ON ADAPTER.DQ_TRANSMISSION_LOG
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
begin
    if :NEW.DQ_TRANSMISSION_ID is null then
        :new.DQ_TRANSMISSION_ID := DQ_TRANSMISSION_ID_SEQ.NEXTVAL;
    end if;
end DQ_TRANSMISSION_ID_TRG;
/

ALTER TABLE ADAPTER.DQ_TRANSMISSION_LOG ADD (
  CONSTRAINT DQ_TRANSMISSION_LOG_PK
  PRIMARY KEY
  (DQ_TRANSMISSION_ID)
  USING INDEX ADAPTER.DQ_TRANSMISSION_LOG_PK
  ENABLE VALIDATE);
