CREATE TABLE ADAPTER.DOCUMENT_REFERENCES
(
  DOCUMENT_REFERENCE_ID  NUMBER,
  RESOURCE_ID            VARCHAR2(36 BYTE)                 NOT NULL,
  PATIENT_ID             VARCHAR2(17 BYTE)                 NOT NULL,
  CREATED_TIME           TIMESTAMP(6) WITH LOCAL TIME ZONE NOT NULL,
  LAST_UPDATED_TIME      TIMESTAMP(6) WITH LOCAL TIME ZONE NOT NULL,
  FHIR_RESOURCE          BLOB
);


CREATE UNIQUE INDEX ADAPTER.DOCUMENT_REFERENCES_PK ON ADAPTER.DOCUMENT_REFERENCES
(DOCUMENT_REFERENCE_ID);

CREATE UNIQUE INDEX ADAPTER.DOCUMENT_REFERENCES_UK1 ON ADAPTER.DOCUMENT_REFERENCES
(RESOURCE_ID);

CREATE OR REPLACE TRIGGER ADAPTER.DOCUMENT_REFERENCE_ID_TRG
BEFORE INSERT
ON ADAPTER.DOCUMENT_REFERENCES
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
begin
  if :NEW.DOCUMENT_REFERENCE_ID is null then
    :new.DOCUMENT_REFERENCE_ID := DOCUMENT_REFERENCE_ID_SEQ.NEXTVAL;
  end if;
end;
/


ALTER TABLE ADAPTER.DOCUMENT_REFERENCES ADD (
  CONSTRAINT DOCUMENT_REFERENCES_PK
  PRIMARY KEY
  (DOCUMENT_REFERENCE_ID)
  USING INDEX ADAPTER.DOCUMENT_REFERENCES_PK
  ENABLE VALIDATE);
