CREATE TABLE ADAPTER.BINARIES
(
  BINARY_ID          NUMBER,
  RESOURCE_ID        VARCHAR2(36 BYTE)                 NOT NULL,
  CREATED_TIME       TIMESTAMP(6) WITH LOCAL TIME ZONE NOT NULL,
  LAST_UPDATED_TIME  TIMESTAMP(6) WITH LOCAL TIME ZONE NOT NULL,
  FHIR_RESOURCE      BLOB
);


CREATE UNIQUE INDEX ADAPTER.BINARIES_PK ON ADAPTER.BINARIES
(BINARY_ID);

CREATE UNIQUE INDEX ADAPTER.BINARIES_UK1 ON ADAPTER.BINARIES
(RESOURCE_ID);

CREATE OR REPLACE TRIGGER ADAPTER.BINARY_ID_TRG
BEFORE INSERT
ON ADAPTER.BINARIES
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
BEGIN
-- For Toad:  Highlight column BINARY_ID
  if :NEW.BINARY_ID is null then
    :NEW.BINARY_ID := BINARY_ID_SEQ.NEXTVAL;
  end if;
END BINARY_ID_TRG;
/


ALTER TABLE ADAPTER.BINARIES ADD (
  CONSTRAINT BINARIES_PK
  PRIMARY KEY
  (BINARY_ID)
  USING INDEX ADAPTER.BINARIES_PK
  ENABLE VALIDATE);
