CREATE TABLE ADAPTER.AUDITS
(
  AUDIT_ID                  NUMBER              NOT NULL,
  ACTION_NAME               VARCHAR2(255 BYTE)  NOT NULL,
  USER_ID                   VARCHAR2(255 BYTE),
  SYSTEM_ID                 VARCHAR2(255 BYTE),
  ORGANIZATION_ID           VARCHAR2(255 BYTE),
  PATIENT_ID                VARCHAR2(255 BYTE),
  PURPOSE_FOR_USE           VARCHAR2(255 BYTE),
  DOCUMENT_ID               VARCHAR2(255 BYTE),
  AUDIT_TIME                TIMESTAMP(6)        NOT NULL,
  OPTOUT_REASON_ID          NUMBER,
  REMOTE_ORGANIZATION_ID    VARCHAR2(255 BYTE),
  REMOTE_DOC_REPOSITORY_ID  VARCHAR2(255 BYTE),
  REMOTE_DOC_ID             VARCHAR2(255 BYTE),
  DETAILS                   VARCHAR2(4000 BYTE),
  PATIENT_LAST_NAME         VARCHAR2(255 BYTE),
  PATIENT_GIVEN_NAME        VARCHAR2(255 BYTE),
  PATIENT_FACILITY_NUMBER   VARCHAR2(20 BYTE),
  PATIENT_FACILITY_NAME     VARCHAR2(255 BYTE),
  PATIENT_SSN               VARCHAR2(20 BYTE),
  USER_NAME                 VARCHAR2(255 BYTE),
  USER_FACILITY_NUMBER      VARCHAR2(255 BYTE),
  USER_FACILITY_NAME        VARCHAR2(255 BYTE),
  USER_ROLE                 VARCHAR2(255 BYTE),
  PATIENT_MIDDLE_NAME       VARCHAR2(255 BYTE),
  MOTHER_MAIDEN_NAME        VARCHAR2(255 BYTE),
  POB_CITY                  VARCHAR2(50 BYTE),
  POB_STATE                 VARCHAR2(50 BYTE),
  DOC_SPEC_TYPE             VARCHAR2(255 BYTE),
  HIE_TRANSACTION_ID        VARCHAR2(36 CHAR)
);


CREATE UNIQUE INDEX ADAPTER.AUDITS_UK ON ADAPTER.AUDITS
(AUDIT_ID);

CREATE INDEX ADAPTER.NDX_AUDITS_ACTION_NAME ON ADAPTER.AUDITS
(ACTION_NAME);

CREATE INDEX ADAPTER.NDX_AUDITS_AUDIT_TIME ON ADAPTER.AUDITS
(AUDIT_TIME);

CREATE OR REPLACE TRIGGER ADAPTER.AUDIT_ID_TRG 
BEFORE INSERT
ON ADAPTER.AUDITS 
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
declare
  N NUMBER;
begin
  if :NEW.AUDIT_ID is null then
      select AUDIT_ID_SEQ.NEXTVAL into N from DUAL;
      :new.AUDIT_ID := N;
  end if;
end AUDIT_ID_TRG;
/


ALTER TABLE ADAPTER.AUDITS ADD (
  PRIMARY KEY
  (AUDIT_ID)
  USING INDEX ADAPTER.AUDITS_UK
  ENABLE VALIDATE);
