select a.ACTION_NAME, a.ORGANIZATION_ID, a.REMOTE_ORGANIZATION_ID, a.PATIENT_FACILITY_NUMBER,
       rf.FACILITY_NAME REMOTE_FACILITY_NAME, rf.FACILITY_NUMBER REMOTE_FACILITY_NUMBER,
       a.AUDIT_TIME, d.DOCUMENT_ID, d.CLASS_CODE, d.FORMAT_CODE, d.RAW_DATA  
from ADAPTER.AUDITS a
inner join ADAPTER.DOCUMENTS d on a.DOCUMENT_ID = d.DOCUMENT_UNIQUE_ID
left outer join ADAPTER.FACILITIES rf on a.REMOTE_ORGANIZATION_ID = rf.FACILITY_ID
where a.ACTION_NAME in ('Retrieve Document', 'RetrieveDocumentOut')
and a.ACTION_NAME = 'Retrieve Document' and 1=1
and a.AUDIT_TIME >= TO_DATE('12/01/2017', 'MM/DD/YYYY') and a.AUDIT_TIME < TO_DATE('12/05/2017', 'MM/DD/YYYY')
order by a.AUDIT_TIME;

