select *
from ADAPTER.AUDITS a
left outer join ADAPTER.DOCUMENTS d on d.DOCUMENT_UNIQUE_ID = a.DOCUMENT_ID
left outer join ADAPTER.FACILITIES f on f.FULL_HOME_COMMUNITY_ID = a.REMOTE_ORGANIZATION_ID
where a.ACTION_NAME in ('RetrieveDocumentOut', 'Retrieve Document')
and a.AUDIT_TIME >= TO_DATE('08/13/2017 00:00:00', 'MM/DD/YYYY HH24:MI:SS')
and a.AUDIT_TIME < TO_DATE('08/20/2017 00:00:00', 'MM/DD/YYYY HH24:MI:SS')
order by a.AUDIT_TIME;
