set echo on
set feedback on
set serveroutput on
var start_date  varchar2(80);
var end_date    varchar2(80);
var sid         varchar2(10);
var host        varchar2(30);
var user        varchar2(30);


spool &1.DBPurge_20180531.&2..log;

begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :start_date from dual;
  select instance_name into :sid from v$instance;
  select host_name into :host from v$instance;
  select user into :user from dual;

  dbms_output.put_line('Script executed on SID:  '||:sid);
  dbms_output.put_line('Script executed on host: '||:host);
  dbms_output.put_line('Script start date/time:  '||:start_date);
  dbms_output.put_line('Script executed by:      '||:user);
end;
/

set define ofF;

// Purge documents data from DOCUMENTS table that are older than 30 days and that have not been accessed.
declare
  CNT INTEGER;
begin
  CNT := ADAPTER.ADAPTER_PKG.PURGE_DOCUMENTS_NOT_DISCLOSED(TO_DATE('01 JAN 2009'), TO_DATE('01 APR 2018'), 7, 50000, 10, null);
  DBMS_OUTPUT.PUT_LINE('Purged ' || CNT || ' records from DOCUMENTS table.');
end;
/

set define on;

Begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :end_date from dual;
  dbms_output.put_line('Script end date/time:    '||:end_date);
  dbms_output.put_line('Script executed in '||(to_date(:end_date, 'mm_dd_yyyy hh24:mi:ss') - to_date(:start_date, 'mm-dd-yyyy hh24:mi:ss')) *24*60*60||' seconds');
end;
/

spool off
quit
