set echo on
set feedback on
set serveroutput on
var start_date  varchar2(80);
var end_date    varchar2(80);
var sid         varchar2(10);
var host        varchar2(30);
var user        varchar2(30);
spool &1.DBPurge_20180522.&2..log;

begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :start_date from dual;
  select instance_name into :sid from v$instance;
  select host_name into :host from v$instance;
  select user into :user from dual;

  dbms_output.put_line('Script executed on SID:  '||:sid);
  dbms_output.put_line('Script executed on host: '||:host);
  dbms_output.put_line('Script start date/time:  '||:start_date);
  dbms_output.put_line('Script executed by:      '||:user);
end;
/

set define ofF;

// Create ADAPTER_PKG.
/* Formatted on 5/21/2018 4:13:29 PM (QP5 v5.287) */
create or replace package ADAPTER.ADAPTER_PKG as
    /******************************************************************************
       NAME:       ADAPTER_PKG
       PURPOSE:

       REVISIONS:
       Ver        Date        Author           Description
       ---------  ----------  ---------------  ------------------------------------
       1.0        3/26/2018      PII       1. Created this package.
       2.0        5/21/2018      PII       1. Updates for purging DOCUMENTS and refreshing snapshot.
    ******************************************************************************/



    function PURGE_AUDITS_PD_AUDIT_REPORT(
        BEGIN_DATE                   AUDITS.AUDIT_TIME%type,
        END_DATE                     AUDITS.AUDIT_TIME%type,
        DAYS_PER_QUERY               integer,
        RECORDS_PER_COMMIT           integer,
        COMMITS_BETWEEN_REFRESHES    integer,
        MAX_RECORDS                  integer)
        return number;

    function PURGE_DOCUMENTS_NOT_DISCLOSED(
        BEGIN_DATE                   DOCUMENTS.CREATION_TIME%type,
        END_DATE                     DOCUMENTS.CREATION_TIME%type,
        DAYS_PER_QUERY               integer,
        RECORDS_PER_COMMIT           integer,
        COMMITS_BETWEEN_REFRESHES    integer,
        MAX_RECORDS                  integer)
        return number;
end ADAPTER_PKG;
/

/* Formatted on 5/21/2018 4:22:51 PM (QP5 v5.287) */
create or replace package body ADAPTER.ADAPTER_PKG as
    /******************************************************************************
       NAME:       ADAPTER.ADAPTER_PKG
       PURPOSE:

       REVISIONS:
       Ver        Date        Author           Description
       ---------  ----------  ---------------  ------------------------------------
       1.0        3/26/2018      PII       1. Created this package body.
       2.0        5/21/2018      PII       1. Updates for purging DOCUMENTS and refreshing snapshot.
    ******************************************************************************/



    function GET_NEXT_END_DATE(CUR_BEGIN_DATE    timestamp,
                               END_DATE          timestamp,
                               DAYS_PER_QUERY    integer)
        return timestamp as
        RET   timestamp;
    begin
        if CUR_BEGIN_DATE + DAYS_PER_QUERY >= END_DATE then
            RET := END_DATE;
        else
            RET := CUR_BEGIN_DATE + DAYS_PER_QUERY;
        end if;

        return RET;
    end GET_NEXT_END_DATE;

    function PURGE_AUDITS_PD_AUDIT_REPORT(
        BEGIN_DATE                   AUDITS.AUDIT_TIME%type,
        END_DATE                     AUDITS.AUDIT_TIME%type,
        DAYS_PER_QUERY               integer,
        RECORDS_PER_COMMIT           integer,
        COMMITS_BETWEEN_REFRESHES    integer,
        MAX_RECORDS                  integer)
        return number as
        RET              integer := 0;
        CUR_BEGIN_DATE   AUDITS.AUDIT_TIME%type := BEGIN_DATE;
        CUR_END_DATE     AUDITS.AUDIT_TIME%type;
        COMMITS_LEFT     integer;

        cursor AUDITS_CURSOR(S    AUDITS.AUDIT_TIME%type,
                             E    AUDITS.AUDIT_TIME%type) is
            select A.AUDIT_ID
              from AUDITS A
             where     A.AUDIT_TIME >= S
                   and A.AUDIT_TIME < E
                   and ACTION_NAME in ('AddPatientCorrelation',
                                       'NoCorrelationPatientDiscovery',
                                       'PatientDiscoveryOut',
                                       'Announce',
                                       'MPI findMatch',
                                       'CheckPolicy');

        type AUDITS_TABLE_TYPE is table of number
            index by binary_integer;

        AUDITS_TABLE     AUDITS_TABLE_TYPE;
    begin
        while     CUR_BEGIN_DATE < END_DATE
              and (MAX_RECORDS is null or RET <= MAX_RECORDS) loop
            CUR_END_DATE :=
                GET_NEXT_END_DATE(CUR_BEGIN_DATE, END_DATE, DAYS_PER_QUERY);

            DBMS_OUTPUT.PUT_LINE(
                   'Deleting records in range '
                || TO_CHAR(CUR_BEGIN_DATE, 'MM/DD/YYYY')
                || ' - '
                || TO_CHAR(CUR_END_DATE, 'MM/DD/YYYY'));

            loop
                open AUDITS_CURSOR(CUR_BEGIN_DATE, CUR_END_DATE);

                COMMITS_LEFT := COMMITS_BETWEEN_REFRESHES;

                while COMMITS_LEFT > 0 loop
                    fetch AUDITS_CURSOR
                        bulk collect into AUDITS_TABLE
                        limit RECORDS_PER_COMMIT;

                    exit when AUDITS_TABLE.COUNT = 0;

                    forall CNT in AUDITS_TABLE.FIRST .. AUDITS_TABLE.LAST
                        delete from AUDITS
                              where AUDIT_ID = AUDITS_TABLE(CNT);

                    RET := RET + AUDITS_TABLE.COUNT;

                    commit;

                    COMMITS_LEFT := COMMITS_LEFT - 1;

                    DBMS_OUTPUT.PUT_LINE(
                           '  Commit after '
                        || AUDITS_TABLE.COUNT
                        || ' deletes.');
                    DBMS_OUTPUT.PUT_LINE(
                        '  Commits left before refresh: ' || COMMITS_LEFT);
                end loop;

                close AUDITS_CURSOR;

                exit when AUDITS_TABLE.COUNT = 0;
            end loop;

            commit;

            DBMS_OUTPUT.PUT_LINE(
                   'Done deleting records in range '
                || TO_CHAR(CUR_BEGIN_DATE, 'MM/DD/YYYY')
                || ' - '
                || TO_CHAR(CUR_END_DATE, 'MM/DD/YYYY'));
            DBMS_OUTPUT.PUT_LINE('Total records deleted so far: ' || RET);

            CUR_BEGIN_DATE := CUR_BEGIN_DATE + DAYS_PER_QUERY;
        end loop;

        DBMS_OUTPUT.PUT_LINE(
               'Done deleting records in range '
            || TO_CHAR(BEGIN_DATE, 'MM/DD/YYYY')
            || ' - '
            || TO_CHAR(END_DATE, 'MM/DD/YYYY'));
        DBMS_OUTPUT.PUT_LINE('Total records deleted: ' || RET);
        return RET;
    exception
        when others then
            if AUDITS_CURSOR%isopen then
                close AUDITS_CURSOR;
            end if;

            DBMS_OUTPUT.PUT_LINE(
                   'Error occurred while deleting audits in range '
                || TO_CHAR(CUR_BEGIN_DATE, 'MM/DD/YYYY')
                || ' - '
                || TO_CHAR(CUR_END_DATE, 'MM/DD/YYYY'));
            DBMS_OUTPUT.PUT_LINE('Error Code: ' || SQLCODE);
            DBMS_OUTPUT.PUT_LINE('Error Message: ' || SQLERRM);
            return -1;
    end PURGE_AUDITS_PD_AUDIT_REPORT;

    function PURGE_DOCUMENTS_NOT_DISCLOSED(
        BEGIN_DATE                   DOCUMENTS.CREATION_TIME%type,
        END_DATE                     DOCUMENTS.CREATION_TIME%type,
        DAYS_PER_QUERY               integer,
        RECORDS_PER_COMMIT           integer,
        COMMITS_BETWEEN_REFRESHES    integer,
        MAX_RECORDS                  integer)
        return number as
        RET               integer := 0;
        CUR_BEGIN_DATE    DOCUMENTS.CREATION_TIME%type := BEGIN_DATE;
        CUR_END_DATE      DOCUMENTS.CREATION_TIME%type;
        COMMITS_LEFT      integer;

        cursor DOCUMENTS_CURSOR(
            S    DOCUMENTS.CREATION_TIME%type,
            E    DOCUMENTS.CREATION_TIME%type) is
            select D.DOCUMENT_ID
              from DOCUMENTS D
             where     D.LAST_ACCESSED_TIME is null
                   and (   D.CREATION_TIME is null
                        or (D.CREATION_TIME >= S and D.CREATION_TIME < E));

        type DOCUMENTS_TABLE_TYPE is table of number
            index by binary_integer;

        DOCUMENTS_TABLE   DOCUMENTS_TABLE_TYPE;
    begin
        while     CUR_BEGIN_DATE < END_DATE
              and (MAX_RECORDS is null or RET < MAX_RECORDS) loop
            CUR_END_DATE :=
                GET_NEXT_END_DATE(CUR_BEGIN_DATE, END_DATE, DAYS_PER_QUERY);

            DBMS_OUTPUT.PUT_LINE(
                   'Deleting records in range '
                || TO_CHAR(CUR_BEGIN_DATE, 'MM/DD/YYYY')
                || ' - '
                || TO_CHAR(CUR_END_DATE, 'MM/DD/YYYY'));

            loop
                open DOCUMENTS_CURSOR(CUR_BEGIN_DATE, CUR_END_DATE);

                COMMITS_LEFT := COMMITS_BETWEEN_REFRESHES;

                while COMMITS_LEFT > 0 loop
                    fetch DOCUMENTS_CURSOR
                        bulk collect into DOCUMENTS_TABLE
                        limit RECORDS_PER_COMMIT;

                    exit when DOCUMENTS_TABLE.COUNT = 0;

                    forall CNT
                        in DOCUMENTS_TABLE.FIRST .. DOCUMENTS_TABLE.LAST
                        delete from DOCUMENTS
                              where DOCUMENT_ID = DOCUMENTS_TABLE(CNT);

                    RET := RET + DOCUMENTS_TABLE.COUNT;

                    commit;

                    COMMITS_LEFT := COMMITS_LEFT - 1;
                    
                    DBMS_OUTPUT.PUT_LINE(
                           '  Commit after '
                        || DOCUMENTS_TABLE.COUNT
                        || ' deletes.');
                    DBMS_OUTPUT.PUT_LINE(
                        'Commits left before refresh: ' || COMMITS_LEFT);
                end loop;

                close DOCUMENTS_CURSOR;

                exit when DOCUMENTS_TABLE.COUNT = 0;
            end loop;

            commit;

            DBMS_OUTPUT.PUT_LINE(
                   'Done deleting records in range '
                || TO_CHAR(CUR_BEGIN_DATE, 'MM/DD/YYYY')
                || ' - '
                || TO_CHAR(CUR_END_DATE, 'MM/DD/YYYY'));
            DBMS_OUTPUT.PUT_LINE('Total records deleted so far: ' || RET);

            CUR_BEGIN_DATE := CUR_BEGIN_DATE + DAYS_PER_QUERY;
        end loop;

        return RET;
    exception
        when others then
            if DOCUMENTS_CURSOR%isopen then
                close DOCUMENTS_CURSOR;
            end if;

            DBMS_OUTPUT.PUT_LINE(
                   'Error occurred while deleting documents in range '
                || TO_CHAR(CUR_BEGIN_DATE, 'MM/DD/YYYY')
                || ' - '
                || TO_CHAR(CUR_END_DATE, 'MM/DD/YYYY'));
            DBMS_OUTPUT.PUT_LINE('Error Code: ' || SQLCODE);
            DBMS_OUTPUT.PUT_LINE('Error Message: ' || SQLERRM);
            return -1;
    end PURGE_DOCUMENTS_NOT_DISCLOSED;
end ADAPTER_PKG;
/

// Purge PD Audit Report data from AUDITS table that is older than 6 months.
declare
  CNT INTEGER;
begin
  CNT := ADAPTER.ADAPTER_PKG.PURGE_AUDITS_PD_AUDIT_REPORT(TO_DATE('01 JAN 2009'), TO_DATE('01 DEC 2017'), 7, 50000, 10, null);
  DBMS_OUTPUT.PUT_LINE('Purged ' || CNT || ' records from AUDITS table.');
end;
/

set define on;

Begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :end_date from dual;
  dbms_output.put_line('Script end date/time:    '||:end_date);
  dbms_output.put_line('Script executed in '||(to_date(:end_date, 'mm_dd_yyyy hh24:mi:ss') - to_date(:start_date, 'mm-dd-yyyy hh24:mi:ss')) *24*60*60||' seconds');
end;
/

spool off
quit
