/* 1. Add new conditional columns */
alter table ADAPTER.INT_FAC_FILT add COND_ROOT_NAME    VARCHAR2(255 BYTE);
alter table ADAPTER.INT_FAC_FILT add COND_OBJ_NAME     VARCHAR2(255 BYTE);
alter table ADAPTER.INT_FAC_FILT add COND_PARAM        VARCHAR2(255 BYTE);
alter table ADAPTER.INT_FAC_FILT add COND_FILTER_ID		INTEGER;	

/* 2. Alter the view that selects by facitlity_id */
CREATE OR REPLACE VIEW INT_FAC_FILT_VIEW AS
SELECT
FAC_FILT_ID,FACILITY_NAME,FACILITY_NUMBER,FILTER_NAME,ROOT_NAME,OBJ_NAME,PARAM,COND_ROOT_NAME,COND_OBJ_NAME,COND_PARAM,COND_FILTER_ID
FROM
(
   (
      ADAPTER.INT_FAC_FILT S
      INNER JOIN ADAPTER.INT_FACILITIES F ON S.FACILITY_ID = F.FACILITY_ID
   )
   INNER JOIN ADAPTER.INT_FILT_CONST V ON S.FILTER_ID = V.FILTER_ID
)

/* 3. Add these rows in constants to enable filtering by regex */
/* Regex = ^.*(?1)(C&P|C & P|Comp and Pen|Compensation and Pension|Compensation & Pension|Compensation&Pension).*$ */
insert into ADAPTER.INT_FILT_CONST (filter_id, filter_name) values (9, 'CONTAINS_REGEX');
insert into ADAPTER.INT_FILT_CONST (filter_id, filter_name) values (10, 'NOT_CONTAINS_REGEX');

/* 4. Insert the new conditional rows */
INSERT INTO ADAPTER.INT_FAC_FILT VALUES (110, 1, 7, 'consultnotes', 'signingClinician.dateTime', '30','consultnotes', 'nationalTitle', '^.*(?i)(C&P|C & P|Comp and Pen|Compensation and Pension|Compensation & Pension|Compensation&Pension).*$',null);

INSERT INTO ADAPTER.INT_FAC_FILT VALUES (111, 1, 7, 'progressNotes', 'signingClinician.dateTime', '30','progressNotes', 'nationalTitle', '^.*(?i)(C&P|C & P|Comp and Pen|Compensation and Pension|Compensation & Pension|Compensation&Pension).*$',null);

/* To start using a 30 day hold, run UPDATE INT_FAC_FILT SET COND_FILTER_ID = 9 WHERE FAC_FILT_ID IN (110,111);  */




