  CREATE OR REPLACE FORCE VIEW "ADAPTER"."AUDITS_REPORT" ("AUDIT_ID", "ACTION_NAME", "USER_ID", "ORGANIZATION_ID", "PATIENT_ID", "PURPOSE_FOR_USE", "DOCUMENT_ID", "AUDIT_TIME", "OPTOUT_REASON_ID", "REMOTE_ORGANIZATION_ID", "REMOTE_DOC_REPOSITORY_ID", "REMOTE_DOC_ID", "CLASS_CODE", "TITLE", "RAW_DATA_SIZE", "DETAILS", "PATIENT_LAST_NAME", "PATIENT_MIDDLE_NAME", "PATIENT_GIVEN_NAME", "MOTHER_MAIDEN_NAME", "POB_CITY", "POB_STATE", "USER_NAME", "PATIENT_FACILITY_NUMBER", "PATIENT_SSN", "PATIENT_FACILITY_NAME", "USER_FACILITY_NUMBER", "USER_FACILITY_NAME", "ORGANIZATION_NAME", "REMOTE_ORGANIZATION_NAME", "OPTOUT_REASON_TEXT", "DOCUMENT_TITLE", "DOCUMENT_SOURCE_PATIENT_ID", "USER_ROLE", "DOC_SPEC_TYPE", "PATIENT_SSN_EX", "MATCH_FOUND", "MATCH_FAILED", "IS_TEST_PATIENT", "HIE_TRANSACTION_ID") AS 
  SELECT b.AUDIT_ID, 
       b.ACTION_NAME, 
       b.USER_ID, 
       b.ORGANIZATION_ID, 
       b.PATIENT_ID, 
       b.PURPOSE_FOR_USE, 
       b.DOCUMENT_ID, 
       b.AUDIT_TIME, 
       b.OPTOUT_REASON_ID, 
       b.REMOTE_ORGANIZATION_ID, 
       b.REMOTE_DOC_REPOSITORY_ID, 
       b.REMOTE_DOC_ID, 
       b.CLASS_CODE, 
       b.TITLE, 
       b.RAW_DATA_SIZE, 
       b.DETAILS, 
       b.PATIENT_LAST_NAME, 
       b.PATIENT_MIDDLE_NAME, 
       b.PATIENT_GIVEN_NAME, 
       b.MOTHER_MAIDEN_NAME, 
       b.POB_CITY, 
       b.POB_STATE, 
       b.USER_NAME, 
       b.PATIENT_FACILITY_NUMBER, 
       b.PATIENT_SSN, 
       b.PATIENT_FACILITY_NAME, 
       b.USER_FACILITY_NUMBER, 
       b.USER_FACILITY_NAME, 
       b.ORGANIZATION_NAME, 
       b.REMOTE_ORGANIZATION_NAME, 
       b.OPTOUT_REASON_TEXT, 
       b.DOCUMENT_TITLE, 
       b.DOCUMENT_SOURCE_PATIENT_ID, 
       b.USER_ROLE, 
       b.DOC_SPEC_TYPE, 
       b.PATIENT_SSN_EX, 
       b.MATCH_FOUND, 
       b.MATCH_FAILED, 
       (case 
           when b.PATIENT_SSN_EX is null then 
               0 /* Null entries aren't considered test */ 
           when  
               substr(b.PATIENT_SSN_EX, 1, 3) = '000' or /* Area number cannot be 000 */ 
               substr(b.PATIENT_SSN_EX, 1, 3) = '666' or /* Area number cannot be 666 */ 
               substr(b.PATIENT_SSN_EX, 1, 1) = '9'   or /* Area number cannot be in 900-999 range */ 
               substr(b.PATIENT_SSN_EX, 4, 2) = '00'  or /* Group number cannot be 00 */ 
               substr(b.PATIENT_SSN_EX, 6, 4) = '0000'   /* Serial number cannot be 0000 */ then 
               1 
           else 
               0 
       end) IS_TEST_PATIENT, 
       b.HIE_TRANSACTION_ID 
FROM ( 
SELECT a.AUDIT_ID, 
       a.ACTION_NAME, 
       UPPER (a.USER_ID) USER_ID, 
       a.ORGANIZATION_ID, 
       UPPER (a.PATIENT_ID) PATIENT_ID, 
       a.PURPOSE_FOR_USE, 
       a.DOCUMENT_ID, 
       a.AUDIT_TIME, 
       a.OPTOUT_REASON_ID, 
       a.REMOTE_ORGANIZATION_ID, 
       a.REMOTE_DOC_REPOSITORY_ID, 
       a.REMOTE_DOC_ID, 
       d.CLASS_CODE, 
       d.TITLE, 
       d.RAW_DATA_SIZE, 
       UPPER (a.DETAILS) DETAILS, 
       (case 
           when a.PATIENT_LAST_NAME is not null then 
               UPPER (a.PATIENT_LAST_NAME) 
           when instr(a.DETAILS, 'lastName=') > 0 then 
               substr(replace(REGEXP_SUBSTR(a.DETAILS, 'lastName=([^,]+)'), '-',''), 10) 
       end) PATIENT_LAST_NAME, 
       (case 
           when a.PATIENT_MIDDLE_NAME is not null then 
               UPPER (a.PATIENT_MIDDLE_NAME) 
           when instr(a.DETAILS, 'middleName=') > 0 then 
               substr(replace(REGEXP_SUBSTR(a.DETAILS, 'middleName=([^,]+)'), '-',''), 12) 
       end) PATIENT_MIDDLE_NAME, 
       (case 
           when a.PATIENT_GIVEN_NAME is not null then 
               UPPER (a.PATIENT_GIVEN_NAME) 
           when instr(a.DETAILS, 'firstName=') > 0 then 
               substr(replace(REGEXP_SUBSTR(a.DETAILS, 'firstName=([^,]+)'), '-',''), 11) 
       end) PATIENT_GIVEN_NAME, 
       UPPER (a.MOTHER_MAIDEN_NAME) MOTHER_MAIDEN_NAME, 
       UPPER (a.POB_CITY) POB_CITY, 
       UPPER (a.POB_STATE) POB_STATE, 
       UPPER (a.USER_NAME) USER_NAME, 
       a.PATIENT_FACILITY_NUMBER, 
       a.PATIENT_SSN, 
       UPPER (a.PATIENT_FACILITY_NAME) PATIENT_FACILITY_NAME, 
       a.USER_FACILITY_NUMBER, 
       UPPER (a.USER_FACILITY_NAME) USER_FACILITY_NAME, 
       UPPER (f1.FACILITY_NAME) ORGANIZATION_NAME, 
       UPPER (f2.FACILITY_NAME) REMOTE_ORGANIZATION_NAME, 
       opt.TEXT OPTOUT_REASON_TEXT, 
       UPPER (d.TITLE) DOCUMENT_TITLE, 
       d.SOURCE_PATIENT_ID DOCUMENT_SOURCE_PATIENT_ID, 
       a.USER_ROLE, 
       a.DOC_SPEC_TYPE, 
       (case 
           when a.PATIENT_SSN is not null then 
               a.PATIENT_SSN 
           when instr(a.DETAILS, 'ssn=') > 0 then 
               substr(replace(REGEXP_SUBSTR(a.DETAILS, 'ssn=([^,]+)'), '-',''), 5) 
       end) PATIENT_SSN_EX, 
       (case 
           when instr(a.details, 'MATCH FOUND') = 1 then 
               1 
           else 
               0 
       end) MATCH_FOUND, 
       (case 
           when instr(a.details, 'MATCH FAILED') = 1 then 
               1 
           else 
               0 
       end) MATCH_FAILED, 
       a.HIE_TRANSACTION_ID 
FROM AUDITS a 
       LEFT OUTER JOIN FACILITIES f1 
           ON a.ORGANIZATION_ID = f1.FULL_HOME_COMMUNITY_ID 
       LEFT OUTER JOIN FACILITIES f2 
           ON a.REMOTE_ORGANIZATION_ID = f2.FULL_HOME_COMMUNITY_ID 
       LEFT OUTER JOIN OPTOUT_REASONS opt 
           ON a.OPTOUT_REASON_ID = opt.OPTOUT_REASON_ID 
       LEFT OUTER JOIN DOCUMENTS d 
           ON a.DOCUMENT_ID = d.DOCUMENT_UNIQUE_ID 
) b;
