set echo on
set feedback on
set serveroutput on
var start_date  varchar2(80);
var end_date    varchar2(80);
var sid         varchar2(10);
var host        varchar2(30);
var user        varchar2(30);


spool 8.2.0_Update_Script_Backout.log;

begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :start_date from dual;
  select instance_name into :sid from v$instance;
  select host_name into :host from v$instance;
  select user into :user from dual;

  dbms_output.put_line('Script executed on SID:  '||:sid);
  dbms_output.put_line('Script executed on host: '||:host);
  dbms_output.put_line('Script start date/time:  '||:start_date);
  dbms_output.put_line('Script executed by:      '||:user);
end;
/

SET DEFINE OFF;

CREATE OR REPLACE FORCE VIEW ADAPTER.AUDITS_REPORT
(
   AUDIT_ID,
   ACTION_NAME,
   USER_ID,
   SYSTEM_ID,
   ORGANIZATION_ID,
   PATIENT_ID,
   PURPOSE_FOR_USE,
   DOCUMENT_ID,
   AUDIT_TIME,
   OPTOUT_REASON_ID,
   REMOTE_ORGANIZATION_ID,
   REMOTE_DOC_REPOSITORY_ID,
   REMOTE_DOC_ID,
   CLASS_CODE, 
   TITLE, 
   RAW_DATA_SIZE,
   DETAILS,
   PATIENT_LAST_NAME,
   PATIENT_MIDDLE_NAME,
   PATIENT_GIVEN_NAME,
   MOTHER_MAIDEN_NAME,
   POB_CITY,
   POB_STATE,
   USER_NAME,
   PATIENT_FACILITY_NUMBER,
   PATIENT_SSN,
   PATIENT_FACILITY_NAME,
   USER_FACILITY_NUMBER,
   USER_FACILITY_NAME,
   ORGANIZATION_NAME,
   REMOTE_ORGANIZATION_NAME,
   OPTOUT_REASON_TEXT,
   DOCUMENT_TITLE,
   DOCUMENT_SOURCE_PATIENT_ID,
   USER_ROLE,
   DOC_SPEC_TYPE,
   PATIENT_SSN_EX,
   MATCH_FOUND,
   MATCH_FAILED,
   IS_TEST_PATIENT,
   HIE_TRANSACTION_ID
)
AS
   SELECT b.AUDIT_ID,
          b.ACTION_NAME,
          b.USER_ID,
          b.SYSTEM_ID,
          b.ORGANIZATION_ID,
          b.PATIENT_ID,
          b.PURPOSE_FOR_USE,
          b.DOCUMENT_ID,
          b.AUDIT_TIME,
          b.OPTOUT_REASON_ID,
          b.REMOTE_ORGANIZATION_ID,
          b.REMOTE_DOC_REPOSITORY_ID,
          b.REMOTE_DOC_ID,
          b.CLASS_CODE, 
          b.TITLE, 
          b.RAW_DATA_SIZE,
          b.DETAILS,
          b.PATIENT_LAST_NAME,
          b.PATIENT_MIDDLE_NAME,
          b.PATIENT_GIVEN_NAME,
          b.MOTHER_MAIDEN_NAME,
          b.POB_CITY,
          b.POB_STATE,
          b.USER_NAME,
          b.PATIENT_FACILITY_NUMBER,
          b.PATIENT_SSN,
          b.PATIENT_FACILITY_NAME,
          b.USER_FACILITY_NUMBER,
          b.USER_FACILITY_NAME,
          b.ORGANIZATION_NAME,
          b.REMOTE_ORGANIZATION_NAME,
          b.OPTOUT_REASON_TEXT,
          b.DOCUMENT_TITLE,
          b.DOCUMENT_SOURCE_PATIENT_ID,
          b.USER_ROLE,
          b.DOC_SPEC_TYPE,
          b.PATIENT_SSN_EX,
          b.MATCH_FOUND,
          b.MATCH_FAILED,
          (CASE
              WHEN b.PATIENT_SSN_EX IS NULL
              THEN
                 0                   /* Null entries aren't considered test */
              WHEN    SUBSTR (b.PATIENT_SSN_EX, 1, 3) = '000'
                   OR                          /* Area number cannot be 000 */
                     SUBSTR (b.PATIENT_SSN_EX, 1, 3) = '666'
                   OR                          /* Area number cannot be 666 */
                     SUBSTR (b.PATIENT_SSN_EX, 1, 1) = '9'
                   OR             /* Area number cannot be in 900-999 range */
                     SUBSTR (b.PATIENT_SSN_EX, 4, 2) = '00'
                   OR                          /* Group number cannot be 00 */
                     SUBSTR (b.PATIENT_SSN_EX, 6, 4) = '0000' /* Serial number cannot be 0000 */
              THEN
                 1
              ELSE
                 0
           END)
             IS_TEST_PATIENT,
          b.HIE_TRANSACTION_ID
     FROM (SELECT a.AUDIT_ID,
                  a.ACTION_NAME,
                  UPPER (a.USER_ID) USER_ID,
                  a.SYSTEM_ID,
                  a.ORGANIZATION_ID,
                  UPPER (a.PATIENT_ID) PATIENT_ID,
                  a.PURPOSE_FOR_USE,
                  a.DOCUMENT_ID,
                  a.AUDIT_TIME,
                  a.OPTOUT_REASON_ID,
                  a.REMOTE_ORGANIZATION_ID,
                  a.REMOTE_DOC_REPOSITORY_ID,
                  a.REMOTE_DOC_ID,
                  d.CLASS_CODE, 
                  d.TITLE, 
                  d.RAW_DATA_SIZE,
                  UPPER (a.DETAILS) DETAILS,
                  UPPER (a.PATIENT_LAST_NAME) PATIENT_LAST_NAME,
                  UPPER (a.PATIENT_MIDDLE_NAME) PATIENT_MIDDLE_NAME,
                  UPPER (a.PATIENT_GIVEN_NAME) PATIENT_GIVEN_NAME,
                  UPPER (a.MOTHER_MAIDEN_NAME) MOTHER_MAIDEN_NAME,
                  UPPER (a.POB_CITY) POB_CITY,
                  UPPER (a.POB_STATE) POB_STATE,
                  UPPER (a.USER_NAME) USER_NAME,
                  a.PATIENT_FACILITY_NUMBER,
                  a.PATIENT_SSN,
                  UPPER (a.PATIENT_FACILITY_NAME) PATIENT_FACILITY_NAME,
                  a.USER_FACILITY_NUMBER,
                  UPPER (a.USER_FACILITY_NAME) USER_FACILITY_NAME,
                  UPPER (f1.FACILITY_NAME) ORGANIZATION_NAME,
                  UPPER (f2.FACILITY_NAME) REMOTE_ORGANIZATION_NAME,
                  opt.TEXT OPTOUT_REASON_TEXT,
                  UPPER (d.TITLE) DOCUMENT_TITLE,
                  d.SOURCE_PATIENT_ID DOCUMENT_SOURCE_PATIENT_ID,
                  a.USER_ROLE,
                  a.DOC_SPEC_TYPE,
                  (CASE
                      WHEN a.PATIENT_SSN IS NOT NULL
                      THEN
                         a.PATIENT_SSN
                      WHEN INSTR (a.DETAILS, 'ssn=') > 0
                      THEN
                         SUBSTR (
                            REPLACE (
                               REGEXP_SUBSTR (a.DETAILS, 'ssn=([^,]+)'),
                               '-',
                               ''),
                            5)
                   END)
                     PATIENT_SSN_EX,
                  (CASE
                      WHEN INSTR (a.details, 'MATCH FOUND') = 1 THEN 1
                      ELSE 0
                   END)
                     MATCH_FOUND,
                  (CASE
                      WHEN INSTR (a.details, 'MATCH FAILED') = 1 THEN 1
                      ELSE 0
                   END)
                     MATCH_FAILED,
                  a.HIE_TRANSACTION_ID
             FROM AUDITS a
                  LEFT OUTER JOIN FACILITIES f1
                     ON a.ORGANIZATION_ID = f1.FULL_HOME_COMMUNITY_ID
                  LEFT OUTER JOIN FACILITIES f2
                     ON a.REMOTE_ORGANIZATION_ID = f2.FULL_HOME_COMMUNITY_ID
                  LEFT OUTER JOIN OPTOUT_REASONS opt
                     ON a.OPTOUT_REASON_ID = opt.OPTOUT_REASON_ID
                  LEFT OUTER JOIN DOCUMENTS d
                     ON a.DOCUMENT_ID = d.DOCUMENT_UNIQUE_ID) b;
/

/* Formatted on 5/1/2018 5:26:19 PM (QP5 v5.287) */
create or replace package ADAPTER.ADAPTER_PKG as
    /******************************************************************************
       NAME:       ADAPTER_PKG
       PURPOSE:

       REVISIONS:
       Ver        Date        Author           Description
       ---------  ----------  ---------------  ------------------------------------
       1.0        3/26/2018      PII       1. Created this package.
       2.0        5/21/2018      PII       1. Updates for purging DOCUMENTS and refreshing snapshot.
    ******************************************************************************/



    function PURGE_AUDITS_PD_AUDIT_REPORT(
        BEGIN_DATE                   AUDITS.AUDIT_TIME%type,
        END_DATE                     AUDITS.AUDIT_TIME%type,
        DAYS_PER_QUERY               integer,
        RECORDS_PER_COMMIT           integer,
        COMMITS_BETWEEN_REFRESHES    integer,
        MAX_RECORDS                  integer)
        return number;

    function PURGE_DOCUMENTS_NOT_DISCLOSED(
        BEGIN_DATE                   DOCUMENTS.CREATION_TIME%type,
        END_DATE                     DOCUMENTS.CREATION_TIME%type,
        DAYS_PER_QUERY               integer,
        RECORDS_PER_COMMIT           integer,
        COMMITS_BETWEEN_REFRESHES    integer,
        MAX_RECORDS                  integer)
        return number;
end ADAPTER_PKG;
/
commit;
/* Formatted on 5/1/2018 5:18:59 PM (QP5 v5.287) */
create or replace package body ADAPTER.ADAPTER_PKG as
    /******************************************************************************
       NAME:       ADAPTER.ADAPTER_PKG
       PURPOSE:

       REVISIONS:
       Ver        Date        Author           Description
       ---------  ----------  ---------------  ------------------------------------
       1.0        3/26/2018      PII       1. Created this package body.
       2.0        5/21/2018      PII       1. Updates for purging DOCUMENTS and refreshing snapshot.
    ******************************************************************************/



    function GET_NEXT_END_DATE(CUR_BEGIN_DATE    timestamp,
                               END_DATE          timestamp,
                               DAYS_PER_QUERY    integer)
        return timestamp as
        RET   timestamp;
    begin
        if CUR_BEGIN_DATE + DAYS_PER_QUERY >= END_DATE then
            RET := END_DATE;
        else
            RET := CUR_BEGIN_DATE + DAYS_PER_QUERY;
        end if;

        return RET;
    end GET_NEXT_END_DATE;

    function PURGE_AUDITS_PD_AUDIT_REPORT(
        BEGIN_DATE                   AUDITS.AUDIT_TIME%type,
        END_DATE                     AUDITS.AUDIT_TIME%type,
        DAYS_PER_QUERY               integer,
        RECORDS_PER_COMMIT           integer,
        COMMITS_BETWEEN_REFRESHES    integer,
        MAX_RECORDS                  integer)
        return number as
        RET              integer := 0;
        CUR_BEGIN_DATE   AUDITS.AUDIT_TIME%type := BEGIN_DATE;
        CUR_END_DATE     AUDITS.AUDIT_TIME%type;
        COMMITS_LEFT     integer;

        cursor AUDITS_CURSOR(S    AUDITS.AUDIT_TIME%type,
                             E    AUDITS.AUDIT_TIME%type) is
            select A.AUDIT_ID
              from AUDITS A
             where     A.AUDIT_TIME >= S
                   and A.AUDIT_TIME < E
                   and ACTION_NAME in ('AddPatientCorrelation',
                                       'NoCorrelationPatientDiscovery',
                                       'PatientDiscoveryOut',
                                       'Announce',
                                       'MPI findMatch',
                                       'CheckPolicy');

        type AUDITS_TABLE_TYPE is table of number
            index by binary_integer;

        AUDITS_TABLE     AUDITS_TABLE_TYPE;
    begin
        while     CUR_BEGIN_DATE < END_DATE
              and (MAX_RECORDS is null or RET <= MAX_RECORDS) loop
            CUR_END_DATE :=
                GET_NEXT_END_DATE(CUR_BEGIN_DATE, END_DATE, DAYS_PER_QUERY);

            DBMS_OUTPUT.PUT_LINE(
                   'Deleting records in range '
                || TO_CHAR(CUR_BEGIN_DATE, 'MM/DD/YYYY')
                || ' - '
                || TO_CHAR(CUR_END_DATE, 'MM/DD/YYYY'));

            loop
                open AUDITS_CURSOR(CUR_BEGIN_DATE, CUR_END_DATE);

                COMMITS_LEFT := COMMITS_BETWEEN_REFRESHES;

                while COMMITS_LEFT > 0 loop
                    fetch AUDITS_CURSOR
                        bulk collect into AUDITS_TABLE
                        limit RECORDS_PER_COMMIT;

                    exit when AUDITS_TABLE.COUNT = 0;

                    forall CNT in AUDITS_TABLE.FIRST .. AUDITS_TABLE.LAST
                        delete from AUDITS
                              where AUDIT_ID = AUDITS_TABLE(CNT);

                    RET := RET + AUDITS_TABLE.COUNT;

                    commit;

                    COMMITS_LEFT := COMMITS_LEFT - 1;

                    DBMS_OUTPUT.PUT_LINE(
                           '  Commit after '
                        || AUDITS_TABLE.COUNT
                        || ' deletes.');
                    DBMS_OUTPUT.PUT_LINE(
                        '  Commits left before refresh: ' || COMMITS_LEFT);
                end loop;

                close AUDITS_CURSOR;

                exit when AUDITS_TABLE.COUNT = 0;
            end loop;

            commit;

            DBMS_OUTPUT.PUT_LINE(
                   'Done deleting records in range '
                || TO_CHAR(CUR_BEGIN_DATE, 'MM/DD/YYYY')
                || ' - '
                || TO_CHAR(CUR_END_DATE, 'MM/DD/YYYY'));
            DBMS_OUTPUT.PUT_LINE('Total records deleted so far: ' || RET);

            CUR_BEGIN_DATE := CUR_BEGIN_DATE + DAYS_PER_QUERY;
        end loop;

        DBMS_OUTPUT.PUT_LINE(
               'Done deleting records in range '
            || TO_CHAR(BEGIN_DATE, 'MM/DD/YYYY')
            || ' - '
            || TO_CHAR(END_DATE, 'MM/DD/YYYY'));
        DBMS_OUTPUT.PUT_LINE('Total records deleted: ' || RET);
        return RET;
    exception
        when others then
            if AUDITS_CURSOR%isopen then
                close AUDITS_CURSOR;
            end if;

            DBMS_OUTPUT.PUT_LINE(
                   'Error occurred while deleting audits in range '
                || TO_CHAR(CUR_BEGIN_DATE, 'MM/DD/YYYY')
                || ' - '
                || TO_CHAR(CUR_END_DATE, 'MM/DD/YYYY'));
            DBMS_OUTPUT.PUT_LINE('Error Code: ' || SQLCODE);
            DBMS_OUTPUT.PUT_LINE('Error Message: ' || SQLERRM);
            return -1;
    end PURGE_AUDITS_PD_AUDIT_REPORT;

    function PURGE_DOCUMENTS_NOT_DISCLOSED(
        BEGIN_DATE                   DOCUMENTS.CREATION_TIME%type,
        END_DATE                     DOCUMENTS.CREATION_TIME%type,
        DAYS_PER_QUERY               integer,
        RECORDS_PER_COMMIT           integer,
        COMMITS_BETWEEN_REFRESHES    integer,
        MAX_RECORDS                  integer)
        return number as
        RET               integer := 0;
        CUR_BEGIN_DATE    DOCUMENTS.CREATION_TIME%type := BEGIN_DATE;
        CUR_END_DATE      DOCUMENTS.CREATION_TIME%type;
        COMMITS_LEFT      integer;

        cursor DOCUMENTS_CURSOR(
            S    DOCUMENTS.CREATION_TIME%type,
            E    DOCUMENTS.CREATION_TIME%type) is
            select D.DOCUMENT_ID
              from DOCUMENTS D
             where     D.LAST_ACCESSED_TIME is null
                   and (   D.CREATION_TIME is null
                        or (D.CREATION_TIME >= S and D.CREATION_TIME < E));

        type DOCUMENTS_TABLE_TYPE is table of number
            index by binary_integer;

        DOCUMENTS_TABLE   DOCUMENTS_TABLE_TYPE;
    begin
        while     CUR_BEGIN_DATE < END_DATE
              and (MAX_RECORDS is null or RET < MAX_RECORDS) loop
            CUR_END_DATE :=
                GET_NEXT_END_DATE(CUR_BEGIN_DATE, END_DATE, DAYS_PER_QUERY);

            DBMS_OUTPUT.PUT_LINE(
                   'Deleting records in range '
                || TO_CHAR(CUR_BEGIN_DATE, 'MM/DD/YYYY')
                || ' - '
                || TO_CHAR(CUR_END_DATE, 'MM/DD/YYYY'));

            loop
                open DOCUMENTS_CURSOR(CUR_BEGIN_DATE, CUR_END_DATE);

                COMMITS_LEFT := COMMITS_BETWEEN_REFRESHES;

                while COMMITS_LEFT > 0 loop
                    fetch DOCUMENTS_CURSOR
                        bulk collect into DOCUMENTS_TABLE
                        limit RECORDS_PER_COMMIT;

                    exit when DOCUMENTS_TABLE.COUNT = 0;

                    forall CNT
                        in DOCUMENTS_TABLE.FIRST .. DOCUMENTS_TABLE.LAST
                        delete from DOCUMENTS
                              where DOCUMENT_ID = DOCUMENTS_TABLE(CNT);

                    RET := RET + DOCUMENTS_TABLE.COUNT;

                    commit;

                    COMMITS_LEFT := COMMITS_LEFT - 1;
                    
                    DBMS_OUTPUT.PUT_LINE(
                           '  Commit after '
                        || DOCUMENTS_TABLE.COUNT
                        || ' deletes.');
                    DBMS_OUTPUT.PUT_LINE(
                        'Commits left before refresh: ' || COMMITS_LEFT);
                end loop;

                close DOCUMENTS_CURSOR;

                exit when DOCUMENTS_TABLE.COUNT = 0;
            end loop;

            commit;

            DBMS_OUTPUT.PUT_LINE(
                   'Done deleting records in range '
                || TO_CHAR(CUR_BEGIN_DATE, 'MM/DD/YYYY')
                || ' - '
                || TO_CHAR(CUR_END_DATE, 'MM/DD/YYYY'));
            DBMS_OUTPUT.PUT_LINE('Total records deleted so far: ' || RET);

            CUR_BEGIN_DATE := CUR_BEGIN_DATE + DAYS_PER_QUERY;
        end loop;

        return RET;
    exception
        when others then
            if DOCUMENTS_CURSOR%isopen then
                close DOCUMENTS_CURSOR;
            end if;

            DBMS_OUTPUT.PUT_LINE(
                   'Error occurred while deleting documents in range '
                || TO_CHAR(CUR_BEGIN_DATE, 'MM/DD/YYYY')
                || ' - '
                || TO_CHAR(CUR_END_DATE, 'MM/DD/YYYY'));
            DBMS_OUTPUT.PUT_LINE('Error Code: ' || SQLCODE);
            DBMS_OUTPUT.PUT_LINE('Error Message: ' || SQLERRM);
            return -1;
    end PURGE_DOCUMENTS_NOT_DISCLOSED;
end ADAPTER_PKG;
/

commit;

DROP SYNONYM ADAPTER_APP.VITALS_QUALIFIER;
DROP SYNONYM ADAPTER_APP.VITALS_QUALIFIER_ID_SEQ;

DROP TABLE ADAPTER.VITALS_QUALIFIER CASCADE CONSTRAINTS;

DROP SEQUENCE ADAPTER.VITALS_QUALIFIER_ID_SEQ;

-- reinsert qualifiers back into translations
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41209, 'M', 'ACTUAL', 'M', 'ACTUAL', 'ACTUAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41210, 'M', 'ADULT CUFF', 'M', 'ADULT CUFF', 'ADULT CUFF');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41211, 'M', 'AEROSOL/HUMIDIFIED MASK', 'M', 'AEROSOL/HUMIDIFIED MASK', 'AEROSOL/HUMIDIFIED MASK');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41212, 'M', 'AFTER EXERCISE', 'M', 'AFTER EXERCISE', 'AFTER EXERCISE');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41213, 'M', 'AMBU BAG (BAG VALVE MASK) ', 'M', 'AMBU BAG (BAG VALVE MASK) ', 'AMBU BAG (BAG VALVE MASK) ');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41214, 'T', 'APICAL', 'T', 'APICAL', 'APICAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41215, 'M', 'ARTERIAL LINE', 'M', 'ARTERIAL LINE', 'ARTERIAL LINE');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41216, 'M', 'ASSISTED VENTILATOR', 'M', 'ASSISTED VENTILATOR', 'ASSISTED VENTILATOR');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41217, 'M', 'AT REST', 'M', 'AT REST', 'AT REST');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41218, 'M', 'AUSCULTATE', 'M', 'AUSCULTATE', 'AUSCULTATE');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41219, 'T', 'AV FISTULA (ARTERIOVENOUS FISTULA)', 'T', 'AV FISTULA (ARTERIOVENOUS FISTULA)', 'AV FISTULA (ARTERIOVENOUS FISTULA)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41220, 'T', 'AXILLARY', 'T', 'AXILLARY', 'AXILLARY');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41221, 'M', 'BED', 'M', 'BED', 'BED');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41222, 'T', 'BILATERAL PERIPHERALS', 'T', 'BILATERAL PERIPHERALS', 'BILATERAL PERIPHERALS');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41223, 'M', 'BIPAP (BI-LEVEL POSITIVE AIRWAY PRESSURE)', 'M', 'BIPAP (BI-LEVEL POSITIVE AIRWAY PRESSURE)', 'BIPAP (BI-LEVEL POSITIVE AIRWAY PRESSURE)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41224, 'M', 'BIPAP-CPAP (BI-LEVEL POSITIVE AIRWAY PRESSURE-CONTINUOUS POSITIVE AIRWAY PRESSURE)', 'M', 'BIPAP-CPAP (BI-LEVEL POSITIVE AIRWAY PRESSURE-CONTINUOUS POSITIVE AIRWAY PRESSURE)', 'BIPAP-CPAP (BI-LEVEL POSITIVE AIRWAY PRESSURE-CONTINUOUS POSITIVE AIRWAY PRESSURE)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41225, 'T', 'BRACHIAL', 'T', 'BRACHIAL', 'BRACHIAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41226, 'M', 'CALCULATED', 'M', 'CALCULATED', 'CALCULATED');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41227, 'T', 'CAROTID', 'T', 'CAROTID', 'CAROTID');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41228, 'M', 'CHAIR', 'M', 'CHAIR', 'CHAIR');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41229, 'M', 'CONTROLLED VENTILATOR', 'M', 'CONTROLLED VENTILATOR', 'CONTROLLED VENTILATOR');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41230, 'T', 'CORE', 'T', 'CORE', 'CORE');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41231, 'M', 'CPAP (CONTINUOUS POSITIVE AIRWAY PRESSURE)', 'M', 'CPAP (CONTINUOUS POSITIVE AIRWAY PRESSURE)', 'CPAP (CONTINUOUS POSITIVE AIRWAY PRESSURE)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41232, 'M', 'CUFF-AUTOMATED (AUTOMATED CUFF)', 'M', 'CUFF-AUTOMATED (AUTOMATED CUFF)', 'CUFF-AUTOMATED (AUTOMATED CUFF)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41233, 'M', 'CUFF-MANUAL (MANUAL CUFF)', 'M', 'CUFF-MANUAL (MANUAL CUFF)', 'CUFF-MANUAL (MANUAL CUFF)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41234, 'M', 'DOPPLER', 'M', 'DOPPLER', 'DOPPLER');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41235, 'T', 'DORSALIS PEDIS', 'T', 'DORSALIS PEDIS', 'DORSALIS PEDIS');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41236, 'M', 'DRY', 'M', 'DRY', 'DRY');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41237, 'M', 'ESTIMATED', 'M', 'ESTIMATED', 'ESTIMATED');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41238, 'M', 'FACE TENT', 'M', 'FACE TENT', 'FACE TENT');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41239, 'T', 'FEMORAL', 'T', 'FEMORAL', 'FEMORAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41240, 'M', 'INVASIVE', 'M', 'INVASIVE', 'INVASIVE');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41241, 'T', 'L ARM (LEFT ARM)', 'T', 'L ARM (LEFT ARM)', 'L ARM (LEFT ARM)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41242, 'T', 'L LEG (LEFT LEG)', 'T', 'L LEG (LEFT LEG)', 'L LEG (LEFT LEG)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41243, 'M', 'LARYNGEAL MASK AIRWAY', 'M', 'LARYNGEAL MASK AIRWAY', 'LARYNGEAL MASK AIRWAY');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41244, 'M', 'LEAD', 'M', 'LEAD', 'LEAD');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41245, 'T', 'LEFT', 'T', 'LEFT', 'LEFT');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41246, 'M', 'LG ADULT CUFF', 'M', 'LG ADULT CUFF', 'LG ADULT CUFF');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41247, 'M', 'LIFT SCALE', 'M', 'LIFT SCALE', 'LIFT SCALE');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41248, 'M', 'LYING', 'M', 'LYING', 'LYING');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41249, 'M', 'MASK', 'M', 'MASK', 'MASK');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41250, 'M', 'MONITOR', 'M', 'MONITOR', 'MONITOR');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41251, 'M', 'MUSTACHE CANNULA', 'M', 'MUSTACHE CANNULA', 'MUSTACHE CANNULA');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41252, 'M', 'NASAL CANNULA', 'M', 'NASAL CANNULA', 'NASAL CANNULA');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41253, 'M', 'NON RE-BREATHER (NON REBREATHER)', 'M', 'NON RE-BREATHER (NON REBREATHER)', 'NON RE-BREATHER (NON REBREATHER)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41254, 'M', 'NON-INVASIVE (NONINVASIVE)', 'M', 'NON-INVASIVE (NONINVASIVE)', 'NON-INVASIVE (NONINVASIVE)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41255, 'T', 'ORAL', 'T', 'ORAL', 'ORAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41256, 'M', 'PALPATED', 'M', 'PALPATED', 'PALPATED');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41257, 'M', 'PARTIAL RE-BREATHER (PARTIAL REBREATHER)', 'M', 'PARTIAL RE-BREATHER (PARTIAL REBREATHER)', 'PARTIAL RE-BREATHER (PARTIAL REBREATHER)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41258, 'M', 'PEDIATRIC CUFF', 'M', 'PEDIATRIC CUFF', 'PEDIATRIC CUFF');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41259, 'M', 'PENDANT CANNULA', 'M', 'PENDANT CANNULA', 'PENDANT CANNULA');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41260, 'T', 'PERIPHERAL', 'T', 'PERIPHERAL', 'PERIPHERAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41261, 'T', 'POPLITEAL', 'T', 'POPLITEAL', 'POPLITEAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41262, 'T', 'POSTERIOR TIBIAL', 'T', 'POSTERIOR TIBIAL', 'POSTERIOR TIBIAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41263, 'T', 'R ARM (RIGHT ARM)', 'T', 'R ARM (RIGHT ARM)', 'R ARM (RIGHT ARM)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41264, 'T', 'R LEG (RIGHT LEG)', 'T', 'R LEG (RIGHT LEG)', 'R LEG (RIGHT LEG)');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41265, 'T', 'RADIAL', 'T', 'RADIAL', 'RADIAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41266, 'T', 'RECTAL', 'T', 'RECTAL', 'RECTAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41267, 'M', 'RESERVOIR CANNULA', 'M', 'RESERVOIR CANNULA', 'RESERVOIR CANNULA');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41268, 'T', 'RIGHT', 'T', 'RIGHT', 'RIGHT');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41269, 'M', 'ROOM AIR', 'M', 'ROOM AIR', 'ROOM AIR');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41270, 'M', 'SEMIFOWLERS', 'M', 'SEMIFOWLERS', 'SEMIFOWLERS');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41271, 'M', 'SITTING', 'M', 'SITTING', 'SITTING');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41272, 'T', 'SKIN', 'T', 'SKIN', 'SKIN');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41273, 'M', 'SM ADULT CUFF', 'M', 'SM ADULT CUFF', 'SM ADULT CUFF');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41274, 'M', 'SPONTANEOUS', 'M', 'SPONTANEOUS', 'SPONTANEOUS');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41275, 'M', 'STANDING', 'M', 'STANDING', 'STANDING');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41276, 'M', 'STANDING WEIGHT', 'M', 'STANDING WEIGHT', 'STANDING WEIGHT');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41277, 'M', 'STATED', 'M', 'STATED', 'STATED');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41278, 'T', 'TEMPORAL', 'T', 'TEMPORAL', 'TEMPORAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41279, 'M', 'THIGH CUFF', 'M', 'THIGH CUFF', 'THIGH CUFF');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41280, 'M', 'T-PIECE', 'M', 'T-PIECE', 'T-PIECE');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41281, 'M', 'TRACHEOSTOMY COLLAR', 'M', 'TRACHEOSTOMY COLLAR', 'TRACHEOSTOMY COLLAR');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41282, 'M', 'TRANSTRACHEAL', 'M', 'TRANSTRACHEAL', 'TRANSTRACHEAL');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41283, 'M', 'TRENDELENBURG', 'M', 'TRENDELENBURG', 'TRENDELENBURG');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41284, 'T', 'TYMPANIC', 'T', 'TYMPANIC', 'TYMPANIC');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41285, 'T', 'ULNAR', 'T', 'ULNAR', 'ULNAR');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41286, 'M', 'VENTILATOR', 'M', 'VENTILATOR', 'VENTILATOR');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41287, 'M', 'VENTURI MASK', 'M', 'VENTURI MASK', 'VENTURI MASK');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41288, 'M', 'WHEELCHAIR SCALE', 'M', 'WHEELCHAIR SCALE', 'WHEELCHAIR SCALE');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41289, 'M', 'WITH ACTIVITY', 'M', 'WITH ACTIVITY', 'WITH ACTIVITY');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41290, 'M', 'WITH AMBULATION', 'M', 'WITH AMBULATION', 'WITH AMBULATION');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41291, 'M', 'WITH CAST OR BRACE', 'M', 'WITH CAST OR BRACE', 'WITH CAST OR BRACE');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41292, 'M', 'WITH PROSTHESIS', 'M', 'WITH PROSTHESIS', 'WITH PROSTHESIS');
INSERT INTO ADAPTER.TRANSLATIONS 
	(TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME)
VALUES
	(41293, 'M', 'WITHOUT PROSTHESIS', 'M', 'WITHOUT PROSTHESIS', 'WITHOUT PROSTHESIS');
	
-- revert codesets table
DELETE FROM ADAPTER.CODESETS WHERE
	CODESET_ID=35 AND CODESET='QUALIFIER' AND LOOKUP_TABLE='VITALS_QUALIFIER' AND KEY_FIELD='QUALIFIER' ;
INSERT INTO ADAPTER.CODESETS (CODESET_ID, CODESET, LOOKUP_TABLE, KEY_FIELD) 
	VALUES (30, 'M', 'TRANSLATIONS', 'TARGET_CODE');
INSERT INTO ADAPTER.CODESETS (CODESET_ID, CODESET, LOOKUP_TABLE, KEY_FIELD) 
	VALUES (31, 'T', 'TRANSLATIONS', 'TARGET_CODE');
	
commit;

Set Define on;

Begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :end_date from dual;
  dbms_output.put_line('Script end date/time:    '||:end_date);
  dbms_output.put_line('Script executed in '||(to_date(:end_date, 'mm_dd_yyyy hh24:mi:ss') - to_date(:start_date, 'mm-dd-yyyy hh24:mi:ss')) *24*60*60||' seconds');
end;
/

Spool off;
