set echo on
set feedback on
set serveroutput on
var start_date  varchar2(80);
var end_date    varchar2(80);
var sid         varchar2(10);
var host        varchar2(30);
var user        varchar2(30);


spool 8.2.0_Update_Script.log;

begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :start_date from dual;
  select instance_name into :sid from v$instance;
  select host_name into :host from v$instance;
  select user into :user from dual;

  dbms_output.put_line('Script executed on SID:  '||:sid);
  dbms_output.put_line('Script executed on host: '||:host);
  dbms_output.put_line('Script start date/time:  '||:start_date);
  dbms_output.put_line('Script executed by:      '||:user);
end;
/
SET DEFINE OFF;

 create or replace package ADAPTER.ADAPTER_PKG as
    /******************************************************************************
       NAME:       ADAPTER_PKG
       PURPOSE:

       REVISIONS:
       Ver        Date        Author           Description
       ---------  ----------  ---------------  ------------------------------------
       1.0        3/26/2018      PII       1. Created this package.
       2.0        5/21/2018      PII       1. Updates for purging DOCUMENTS and refreshing snapshot.
    ******************************************************************************/



    function PURGE_AUDITS_PD_AUDIT_REPORT(
        BEGIN_DATE                   AUDITS.AUDIT_TIME%type,
        END_DATE                     AUDITS.AUDIT_TIME%type,
        DAYS_PER_QUERY               integer,
        RECORDS_PER_COMMIT           integer,
        COMMITS_BETWEEN_REFRESHES    integer,
        MAX_RECORDS                  integer)
        return number;

    function PURGE_DOCUMENTS_NOT_DISCLOSED(
        BEGIN_DATE                   DOCUMENTS.CREATION_TIME%type,
        END_DATE                     DOCUMENTS.CREATION_TIME%type,
        DAYS_PER_QUERY               integer,
        RECORDS_PER_COMMIT           integer,
        COMMITS_BETWEEN_REFRESHES    integer,
        MAX_RECORDS                  integer)
        return number;

    function PURGE_AUDITS_TEST_PATIENTS(BEGIN_DATE            AUDITS.AUDIT_TIME%type,
                                        END_DATE              AUDITS.AUDIT_TIME%type,
                                        DAYS_PER_QUERY        integer,
                                        RECORDS_PER_COMMIT    integer,
                                        MAX_RECORDS           integer)
        return number;
		
	FUNCTION GET_IS_TEST_PATIENT(IN_PATIENT_SSN_EX IN VARCHAR)
        RETURN NUMBER;
         
    FUNCTION GET_PATIENT_SSN_EX(PATIENT_SSN IN VARCHAR,DETAILS IN VARCHAR)
        RETURN VARCHAR ;
  
    FUNCTION GET_MATCHINFO(DETAILS IN VARCHAR, MATCHDATA IN VARCHAR)
         RETURN VARCHAR;
end ADAPTER_PKG;
/

create or replace package body ADAPTER.ADAPTER_PKG as
    /******************************************************************************
       NAME:       ADAPTER.ADAPTER_PKG
       PURPOSE:

       REVISIONS:
       Ver        Date        Author           Description
       ---------  ----------  ---------------  ------------------------------------
       1.0        3/26/2018      PII       1. Created this package body.
       2.0        5/21/2018      PII       1. Updates for purging DOCUMENTS and refreshing snapshot.
    ******************************************************************************/



    function GET_NEXT_END_DATE(CUR_BEGIN_DATE    timestamp,
                               END_DATE          timestamp,
                               DAYS_PER_QUERY    integer)
        return timestamp as
        RET   timestamp;
    begin
        if CUR_BEGIN_DATE + DAYS_PER_QUERY >= END_DATE then
            RET := END_DATE;
        else
            RET := CUR_BEGIN_DATE + DAYS_PER_QUERY;
        end if;

        return RET;
    end GET_NEXT_END_DATE;

    function PURGE_AUDITS_PD_AUDIT_REPORT(
        BEGIN_DATE                   AUDITS.AUDIT_TIME%type,
        END_DATE                     AUDITS.AUDIT_TIME%type,
        DAYS_PER_QUERY               integer,
        RECORDS_PER_COMMIT           integer,
        COMMITS_BETWEEN_REFRESHES    integer,
        MAX_RECORDS                  integer)
        return number as
        RET              integer := 0;
        CUR_BEGIN_DATE   AUDITS.AUDIT_TIME%type := BEGIN_DATE;
        CUR_END_DATE     AUDITS.AUDIT_TIME%type;
        COMMITS_LEFT     integer;

        cursor AUDITS_CURSOR(S    AUDITS.AUDIT_TIME%type,
                             E    AUDITS.AUDIT_TIME%type) is
            select A.AUDIT_ID
              from AUDITS A
             where     A.AUDIT_TIME >= S
                   and A.AUDIT_TIME < E
                   and ACTION_NAME in ('AddPatientCorrelation',
                                       'NoCorrelationPatientDiscovery',
                                       'PatientDiscoveryOut',
                                       'Announce',
                                       'MPI findMatch',
                                       'CheckPolicy');

        type AUDITS_TABLE_TYPE is table of number
            index by binary_integer;

        AUDITS_TABLE     AUDITS_TABLE_TYPE;
    begin
        while     CUR_BEGIN_DATE < END_DATE
              and (MAX_RECORDS is null or RET <= MAX_RECORDS) loop
            CUR_END_DATE :=
                GET_NEXT_END_DATE(CUR_BEGIN_DATE, END_DATE, DAYS_PER_QUERY);

            DBMS_OUTPUT.PUT_LINE(
                   'Deleting records in range '
                || TO_CHAR(CUR_BEGIN_DATE, 'MM/DD/YYYY')
                || ' - '
                || TO_CHAR(CUR_END_DATE, 'MM/DD/YYYY'));

            loop
                open AUDITS_CURSOR(CUR_BEGIN_DATE, CUR_END_DATE);

                COMMITS_LEFT := COMMITS_BETWEEN_REFRESHES;

                while COMMITS_LEFT > 0 loop
                    fetch AUDITS_CURSOR
                        bulk collect into AUDITS_TABLE
                        limit RECORDS_PER_COMMIT;

                    exit when AUDITS_TABLE.COUNT = 0;

                    forall CNT in AUDITS_TABLE.FIRST .. AUDITS_TABLE.LAST
                        delete from AUDITS
                              where AUDIT_ID = AUDITS_TABLE(CNT);

                    RET := RET + AUDITS_TABLE.COUNT;

                    commit;

                    COMMITS_LEFT := COMMITS_LEFT - 1;

                    DBMS_OUTPUT.PUT_LINE(
                           '  Commit after '
                        || AUDITS_TABLE.COUNT
                        || ' deletes.');
                    DBMS_OUTPUT.PUT_LINE(
                        '  Commits left before refresh: ' || COMMITS_LEFT);
                end loop;

                close AUDITS_CURSOR;

                exit when AUDITS_TABLE.COUNT = 0;
            end loop;

            commit;

            DBMS_OUTPUT.PUT_LINE(
                   'Done deleting records in range '
                || TO_CHAR(CUR_BEGIN_DATE, 'MM/DD/YYYY')
                || ' - '
                || TO_CHAR(CUR_END_DATE, 'MM/DD/YYYY'));
            DBMS_OUTPUT.PUT_LINE('Total records deleted so far: ' || RET);

            CUR_BEGIN_DATE := CUR_BEGIN_DATE + DAYS_PER_QUERY;
        end loop;

        DBMS_OUTPUT.PUT_LINE(
               'Done deleting records in range '
            || TO_CHAR(BEGIN_DATE, 'MM/DD/YYYY')
            || ' - '
            || TO_CHAR(END_DATE, 'MM/DD/YYYY'));
        DBMS_OUTPUT.PUT_LINE('Total records deleted: ' || RET);
        return RET;
    exception
        when others then
            if AUDITS_CURSOR%isopen then
                close AUDITS_CURSOR;
            end if;

            DBMS_OUTPUT.PUT_LINE(
                   'Error occurred while deleting audits in range '
                || TO_CHAR(CUR_BEGIN_DATE, 'MM/DD/YYYY')
                || ' - '
                || TO_CHAR(CUR_END_DATE, 'MM/DD/YYYY'));
            DBMS_OUTPUT.PUT_LINE('Error Code: ' || SQLCODE);
            DBMS_OUTPUT.PUT_LINE('Error Message: ' || SQLERRM);
            return -1;
    end PURGE_AUDITS_PD_AUDIT_REPORT;

    function PURGE_DOCUMENTS_NOT_DISCLOSED(
        BEGIN_DATE                   DOCUMENTS.CREATION_TIME%type,
        END_DATE                     DOCUMENTS.CREATION_TIME%type,
        DAYS_PER_QUERY               integer,
        RECORDS_PER_COMMIT           integer,
        COMMITS_BETWEEN_REFRESHES    integer,
        MAX_RECORDS                  integer)
        return number as
        RET               integer := 0;
        CUR_BEGIN_DATE    DOCUMENTS.CREATION_TIME%type := BEGIN_DATE;
        CUR_END_DATE      DOCUMENTS.CREATION_TIME%type;
        COMMITS_LEFT      integer;

        cursor DOCUMENTS_CURSOR(
            S    DOCUMENTS.CREATION_TIME%type,
            E    DOCUMENTS.CREATION_TIME%type) is
            select D.DOCUMENT_ID
              from DOCUMENTS D
             where     D.LAST_ACCESSED_TIME is null
                   and (   D.CREATION_TIME is null
                        or (D.CREATION_TIME >= S and D.CREATION_TIME < E));

        type DOCUMENTS_TABLE_TYPE is table of number
            index by binary_integer;

        DOCUMENTS_TABLE   DOCUMENTS_TABLE_TYPE;
    begin
        while     CUR_BEGIN_DATE < END_DATE
              and (MAX_RECORDS is null or RET < MAX_RECORDS) loop
            CUR_END_DATE :=
                GET_NEXT_END_DATE(CUR_BEGIN_DATE, END_DATE, DAYS_PER_QUERY);

            DBMS_OUTPUT.PUT_LINE(
                   'Deleting records in range '
                || TO_CHAR(CUR_BEGIN_DATE, 'MM/DD/YYYY')
                || ' - '
                || TO_CHAR(CUR_END_DATE, 'MM/DD/YYYY'));

            loop
                open DOCUMENTS_CURSOR(CUR_BEGIN_DATE, CUR_END_DATE);

                COMMITS_LEFT := COMMITS_BETWEEN_REFRESHES;

                while COMMITS_LEFT > 0 loop
                    fetch DOCUMENTS_CURSOR
                        bulk collect into DOCUMENTS_TABLE
                        limit RECORDS_PER_COMMIT;

                    exit when DOCUMENTS_TABLE.COUNT = 0;

                    forall CNT
                        in DOCUMENTS_TABLE.FIRST .. DOCUMENTS_TABLE.LAST
                        delete from DOCUMENTS
                              where DOCUMENT_ID = DOCUMENTS_TABLE(CNT);

                    RET := RET + DOCUMENTS_TABLE.COUNT;

                    commit;

                    COMMITS_LEFT := COMMITS_LEFT - 1;
                    
                    DBMS_OUTPUT.PUT_LINE(
                           '  Commit after '
                        || DOCUMENTS_TABLE.COUNT
                        || ' deletes.');
                    DBMS_OUTPUT.PUT_LINE(
                        'Commits left before refresh: ' || COMMITS_LEFT);
                end loop;

                close DOCUMENTS_CURSOR;

                exit when DOCUMENTS_TABLE.COUNT = 0;
            end loop;

            commit;

            DBMS_OUTPUT.PUT_LINE(
                   'Done deleting records in range '
                || TO_CHAR(CUR_BEGIN_DATE, 'MM/DD/YYYY')
                || ' - '
                || TO_CHAR(CUR_END_DATE, 'MM/DD/YYYY'));
            DBMS_OUTPUT.PUT_LINE('Total records deleted so far: ' || RET);

            CUR_BEGIN_DATE := CUR_BEGIN_DATE + DAYS_PER_QUERY;
        end loop;

        return RET;
    exception
        when others then
            if DOCUMENTS_CURSOR%isopen then
                close DOCUMENTS_CURSOR;
            end if;

            DBMS_OUTPUT.PUT_LINE(
                   'Error occurred while deleting documents in range '
                || TO_CHAR(CUR_BEGIN_DATE, 'MM/DD/YYYY')
                || ' - '
                || TO_CHAR(CUR_END_DATE, 'MM/DD/YYYY'));
            DBMS_OUTPUT.PUT_LINE('Error Code: ' || SQLCODE);
            DBMS_OUTPUT.PUT_LINE('Error Message: ' || SQLERRM);
            return -1;
    end PURGE_DOCUMENTS_NOT_DISCLOSED;
    
     FUNCTION GET_IS_TEST_PATIENT(IN_PATIENT_SSN_EX IN VARCHAR)
          RETURN NUMBER
        IS
        BEGIN
                /* Area number cannot be 000 */
                 /* Area number cannot be 666 */
                /* Area number cannot be in 900-999 range */
                /* Group number cannot be 00 */
                /* Serial number cannot be 0000 */
            if (IN_PATIENT_SSN_EX = null) then
                 return 0;
                elsif ( SUBSTR (IN_PATIENT_SSN_EX, 1, 3) = '000'  or
                         SUBSTR (IN_PATIENT_SSN_EX, 1, 3) = '666' or
                         SUBSTR (IN_PATIENT_SSN_EX, 1, 1) = '9' or
                         SUBSTR (IN_PATIENT_SSN_EX, 4, 2) = '00' or
                         SUBSTR (IN_PATIENT_SSN_EX, 6, 4) = '0000' )
                then     return 1;
                else    return 0;
            end if;
        
        END GET_IS_TEST_PATIENT;
        
        FUNCTION GET_PATIENT_SSN_EX(PATIENT_SSN IN VARCHAR,DETAILS IN VARCHAR)
              RETURN VARCHAR
            IS
            BEGIN
                IF (PATIENT_SSN IS NOT NULL) then
                     RETURN PATIENT_SSN;
                ELSIF ( INSTR (DETAILS, 'ssn=') > 0) THEN
                    RETURN SUBSTR (   REPLACE (
                                           REGEXP_SUBSTR (DETAILS, 'ssn=([^,]+)'),
                                           '-',
                                           ''),
                                        5);
                END IF;
                RETURN null;
            END GET_PATIENT_SSN_EX;
            
      FUNCTION GET_MATCHINFO(DETAILS IN VARCHAR, MATCHDATA IN VARCHAR)
                  RETURN VARCHAR
                IS
                BEGIN
                    IF (INSTR (details, MATCHDATA) = 1 ) then
                         RETURN 1;
                    ELSE
                       RETURN 0;
                    END IF;
                
                END GET_MATCHINFO;
end ADAPTER_PKG;
/
/* Formatted on 9/29/2016 4:11:54 PM (QP5 v5.287) */
CREATE OR REPLACE FORCE VIEW ADAPTER.AUDITS_REPORT
(
   AUDIT_ID,
   ACTION_NAME,
   USER_ID,
   SYSTEM_ID,
   ORGANIZATION_ID,
   PATIENT_ID,
   PURPOSE_FOR_USE,
   DOCUMENT_ID,
   AUDIT_TIME,
   OPTOUT_REASON_ID,
   REMOTE_ORGANIZATION_ID,
   REMOTE_DOC_REPOSITORY_ID,
   REMOTE_DOC_ID,
   CLASS_CODE, 
   TITLE, 
   RAW_DATA_SIZE,
   DETAILS,
   PATIENT_LAST_NAME,
   PATIENT_MIDDLE_NAME,
   PATIENT_GIVEN_NAME,
   MOTHER_MAIDEN_NAME,
   POB_CITY,
   POB_STATE,
   USER_NAME,
   PATIENT_FACILITY_NUMBER,
   PATIENT_SSN,
   PATIENT_FACILITY_NAME,
   USER_FACILITY_NUMBER,
   USER_FACILITY_NAME,
   ORGANIZATION_NAME,
   REMOTE_ORGANIZATION_NAME,
   OPTOUT_REASON_TEXT,
   DOCUMENT_TITLE,
   DOCUMENT_SOURCE_PATIENT_ID,
   USER_ROLE,
   DOC_SPEC_TYPE,
   PATIENT_SSN_EX,
   MATCH_FOUND,
   MATCH_FAILED,
   IS_TEST_PATIENT,
   HIE_TRANSACTION_ID
)
AS
   SELECT b.AUDIT_ID,
          b.ACTION_NAME,
          b.USER_ID,
          b.SYSTEM_ID,
          b.ORGANIZATION_ID,
          b.PATIENT_ID,
          b.PURPOSE_FOR_USE,
          b.DOCUMENT_ID,
          b.AUDIT_TIME,
          b.OPTOUT_REASON_ID,
          b.REMOTE_ORGANIZATION_ID,
          b.REMOTE_DOC_REPOSITORY_ID,
          b.REMOTE_DOC_ID,
          b.CLASS_CODE, 
          b.TITLE, 
          b.RAW_DATA_SIZE,
          b.DETAILS,
          b.PATIENT_LAST_NAME,
          b.PATIENT_MIDDLE_NAME,
          b.PATIENT_GIVEN_NAME,
          b.MOTHER_MAIDEN_NAME,
          b.POB_CITY,
          b.POB_STATE,
          b.USER_NAME,
          b.PATIENT_FACILITY_NUMBER,
          b.PATIENT_SSN,
          b.PATIENT_FACILITY_NAME,
          b.USER_FACILITY_NUMBER,
          b.USER_FACILITY_NAME,
          b.ORGANIZATION_NAME,
          b.REMOTE_ORGANIZATION_NAME,
          b.OPTOUT_REASON_TEXT,
          b.DOCUMENT_TITLE,
          b.DOCUMENT_SOURCE_PATIENT_ID,
          b.USER_ROLE,
          b.DOC_SPEC_TYPE,
          b.PATIENT_SSN_EX,
          b.MATCH_FOUND,
          b.MATCH_FAILED,
          ADAPTER_PKG.GET_IS_TEST_PATIENT(b.PATIENT_SSN_EX) IS_TEST_PATIENT,
          b.HIE_TRANSACTION_ID
     FROM (SELECT a.AUDIT_ID,
                  a.ACTION_NAME,
                  UPPER (a.USER_ID) USER_ID,
                  a.SYSTEM_ID,
                  a.ORGANIZATION_ID,
                  UPPER (a.PATIENT_ID) PATIENT_ID,
                  a.PURPOSE_FOR_USE,
                  a.DOCUMENT_ID,
                  a.AUDIT_TIME,
                  a.OPTOUT_REASON_ID,
                  a.REMOTE_ORGANIZATION_ID,
                  a.REMOTE_DOC_REPOSITORY_ID,
                  a.REMOTE_DOC_ID,
                  d.CLASS_CODE, 
                  d.TITLE, 
                  d.RAW_DATA_SIZE,
                  UPPER (a.DETAILS) DETAILS,
                  UPPER (a.PATIENT_LAST_NAME) PATIENT_LAST_NAME,
                  UPPER (a.PATIENT_MIDDLE_NAME) PATIENT_MIDDLE_NAME,
                  UPPER (a.PATIENT_GIVEN_NAME) PATIENT_GIVEN_NAME,
                  UPPER (a.MOTHER_MAIDEN_NAME) MOTHER_MAIDEN_NAME,
                  UPPER (a.POB_CITY) POB_CITY,
                  UPPER (a.POB_STATE) POB_STATE,
                  UPPER (a.USER_NAME) USER_NAME,
                  a.PATIENT_FACILITY_NUMBER,
                  a.PATIENT_SSN,
                  UPPER (a.PATIENT_FACILITY_NAME) PATIENT_FACILITY_NAME,
                  a.USER_FACILITY_NUMBER,
                  UPPER (a.USER_FACILITY_NAME) USER_FACILITY_NAME,
                  UPPER (f1.FACILITY_NAME) ORGANIZATION_NAME,
                  UPPER (f2.FACILITY_NAME) REMOTE_ORGANIZATION_NAME,
                  opt.TEXT OPTOUT_REASON_TEXT,
                  UPPER (d.TITLE) DOCUMENT_TITLE,
                  d.SOURCE_PATIENT_ID DOCUMENT_SOURCE_PATIENT_ID,
                  a.USER_ROLE,
                  a.DOC_SPEC_TYPE,
                  ADAPTER_PKG.GET_PATIENT_SSN_EX(a.PATIENT_SSN,a.DETAILS) PATIENT_SSN_EX,
                  ADAPTER_PKG.GET_MATCHINFO(a.details, 'MATCH FOUND') MATCH_FOUND,
                  ADAPTER_PKG.GET_MATCHINFO(a.details, 'MATCH FAILED') MATCH_FAILED,
                  a.HIE_TRANSACTION_ID
             FROM AUDITS a
                  LEFT OUTER JOIN FACILITIES f1
                     ON a.ORGANIZATION_ID = f1.FULL_HOME_COMMUNITY_ID
                  LEFT OUTER JOIN FACILITIES f2
                     ON a.REMOTE_ORGANIZATION_ID = f2.FULL_HOME_COMMUNITY_ID
                  LEFT OUTER JOIN OPTOUT_REASONS opt
                     ON a.OPTOUT_REASON_ID = opt.OPTOUT_REASON_ID
                  LEFT OUTER JOIN DOCUMENTS d
                     ON a.DOCUMENT_ID = d.DOCUMENT_UNIQUE_ID) b;
/
  
commit;

-- create sequence
CREATE SEQUENCE ADAPTER.VITALS_QUALIFIER_ID_SEQ
  START WITH 1
  MAXVALUE 999999999999999999999999999
  MINVALUE 1
  NOCYCLE
  NOCACHE
  NOORDER;
  
-- create table
CREATE TABLE ADAPTER.VITALS_QUALIFIER (
  QUAL_ID    	NUMBER NOT NULL UNIQUE,
  ELEMENT		VARCHAR2(1)  NOT NULL,
  QUALIFIER		VARCHAR2(255) NOT NULL 
);

-- create pk  
CREATE UNIQUE INDEX ADAPTER.VITALS_QUALIFIER_PK ON ADAPTER.VITALS_QUALIFIER
(QUALIFIER)
TABLESPACE ADAPTER_INDEX01;

ALTER TABLE ADAPTER.VITALS_QUALIFIER ADD (
  CONSTRAINT VITALS_QUALIFIER_PK
  PRIMARY KEY
  (QUALIFIER)
  USING INDEX ADAPTER.VITALS_QUALIFIER_PK
  ENABLE VALIDATE);

-- autoincrement qual id on insertion
CREATE OR REPLACE TRIGGER ADAPTER.VITALS_QUALIFIER_ID_TRIG
BEFORE INSERT
ON ADAPTER.VITALS_QUALIFIER
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
BEGIN
  if :NEW.QUAL_ID is null then
    :NEW.QUAL_ID := VITALS_QUALIFIER_ID_SEQ.NEXTVAL;
  end if;
END VITALS_QUALIFIER_ID_TRIG;
/

-- force pk inserts to uppercase
CREATE OR REPLACE TRIGGER ADAPTER.VITALS_QUALIFIER_QUAL_TRIG
BEFORE INSERT
ON ADAPTER.VITALS_QUALIFIER
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
BEGIN
   :NEW.QUALIFIER := UPPER(:NEW.QUALIFIER);
END VITALS_QUALIFIER_QUAL_TRIG;
/

-- set user perms 
GRANT SELECT ON ADAPTER.VITALS_QUALIFIER_ID_SEQ TO ADAPTER_USER;
GRANT SELECT ON ADAPTER.VITALS_QUALIFIER TO ADAPTER_READ;
GRANT SELECT, UPDATE, INSERT, DELETE ON ADAPTER.VITALS_QUALIFIER TO ADAPTER_USER;

-- set synonyms
CREATE SYNONYM ADAPTER_APP.VITALS_QUALIFIER FOR ADAPTER.VITALS_QUALIFIER;
CREATE SYNONYM ADAPTER_APP.VITALS_QUALIFIER_ID_SEQ FOR ADAPTER.VITALS_QUALIFIER_ID_SEQ;

-- insert qualifer data into new table
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'ACTUAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'ADULT CUFF');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'AEROSOL/HUMIDIFIED MASK');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'AFTER EXERCISE');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'AMBU BAG (BAG VALVE MASK)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'ARTERIAL LINE');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'ASSISTED VENTILATOR');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'AT REST');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'AUSCULTATE');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'BED');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'BIPAP (BI-LEVEL POSITIVE AIRWAY PRESSURE)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'BIPAP-CPAP (BI-LEVEL POSITIVE AIRWAY PRESSURE-CONTINUOUS POSITIVE AIRWAY PRESSURE)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'CALCULATED');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'CHAIR');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'CONTROLLED VENTILATOR');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'CPAP (CONTINUOUS POSITIVE AIRWAY PRESSURE)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'CUFF-AUTOMATED (AUTOMATED CUFF)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'CUFF-MANUAL (MANUAL CUFF)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'DOPPLER');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'DRY');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'ESTIMATED');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'FACE TENT');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'INVASIVE');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'LARYNGEAL MASK AIRWAY');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'LEAD');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'LG ADULT CUFF');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'LIFT SCALE');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'LYING');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'MASK');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'MONITOR');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'MUSTACHE CANNULA');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'NASAL CANNULA');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'NON RE-BREATHER (NON REBREATHER)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'NON-INVASIVE (NONINVASIVE)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'PALPATED');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'PARTIAL RE-BREATHER (PARTIAL REBREATHER)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'PEDIATRIC CUFF');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'PENDANT CANNULA');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'RESERVOIR CANNULA');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'ROOM AIR');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'SEMIFOWLERS');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'SITTING');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'SM ADULT CUFF');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'SPONTANEOUS');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'STANDING');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'STANDING WEIGHT');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'STATED');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'THIGH CUFF');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'T-PIECE');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'TRACHEOSTOMY COLLAR');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'TRANSTRACHEAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'TRENDELENBURG');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'VENTILATOR');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'VENTURI MASK');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'WHEELCHAIR SCALE');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'WITH ACTIVITY');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'WITH AMBULATION');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'WITH CAST OR BRACE');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'WITH PROSTHESIS');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('M', 'WITHOUT PROSTHESIS');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'APICAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'AV FISTULA (ARTERIOVENOUS FISTULA)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'AXILLARY');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'BILATERAL PERIPHERALS');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'BRACHIAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'CAROTID');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'CORE');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'DORSALIS PEDIS');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'FEMORAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'L ARM (LEFT ARM)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'L LEG (LEFT LEG)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'LEFT');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'ORAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'PERIPHERAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'POPLITEAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'POSTERIOR TIBIAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'R ARM (RIGHT ARM)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'R LEG (RIGHT LEG)');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'RADIAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'RECTAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'RIGHT');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'SKIN');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'TEMPORAL');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'TYMPANIC');
INSERT INTO ADAPTER.VITALS_QUALIFIER (ELEMENT, QUALIFIER) VALUES ('T', 'ULNAR');

-- update codeset table
INSERT INTO ADAPTER.CODESETS (CODESET_ID, CODESET, LOOKUP_TABLE, KEY_FIELD) VALUES (35, 'QUALIFIER', 'VITALS_QUALIFIER', 'QUALIFIER');
DELETE FROM ADAPTER.CODESETS WHERE 
  (CODESET_ID=30 AND CODESET='M' AND LOOKUP_TABLE='TRANSLATIONS' AND KEY_FIELD='TARGET_CODE'); 
DELETE FROM ADAPTER.CODESETS WHERE 
  (CODESET_ID=31 AND CODESET='T' AND LOOKUP_TABLE='TRANSLATIONS' AND KEY_FIELD='TARGET_CODE');

-- remove qualifiers from translations table
DELETE FROM ADAPTER.TRANSLATIONS WHERE
	SOURCE_CODESET='M' OR SOURCE_CODESET='T';

commit;

Set Define on;

Begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :end_date from dual;
  dbms_output.put_line('Script end date/time:    '||:end_date);
  dbms_output.put_line('Script executed in '||(to_date(:end_date, 'mm_dd_yyyy hh24:mi:ss') - to_date(:start_date, 'mm-dd-yyyy hh24:mi:ss')) *24*60*60||' seconds');
end;
/

Spool off;
