set echo on
set feedback on
set serveroutput on
var start_date  varchar2(80);
var end_date    varchar2(80);
var sid         varchar2(10);
var host        varchar2(30);
var user        varchar2(30);


spool 8.1.0_Update_Script.log;

begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :start_date from dual;
  select instance_name into :sid from v$instance;
  select host_name into :host from v$instance;
  select user into :user from dual;

  dbms_output.put_line('Script executed on SID:  '||:sid);
  dbms_output.put_line('Script executed on host: '||:host);
  dbms_output.put_line('Script start date/time:  '||:start_date);
  dbms_output.put_line('Script executed by:      '||:user);
end;
/
SET DEFINE OFF;

 CREATE TABLE ADAPTER.AUDIT_LOG4J (
    AUDIT_LOG4J_GUID VARCHAR(32)   DEFAULT RAWTOHEX(SYS_GUID()),
    TRANS_GUID       VARCHAR(36)   NULL,
    CREATED_DATE     TIMESTAMP     NOT NULL,
    MESSAGE_TYPE     VARCHAR(30)   NULL,
    MESSAGE          CLOB          NOT NULL
 )
 LOB (MESSAGE) STORE AS BASICFILE (TABLESPACE ADAPTER_LOBDATA01)
 TABLESPACE ADAPTER_DATA01;

 CREATE UNIQUE INDEX ADAPTER.AUDIT_LOG4J_PK ON ADAPTER.AUDIT_LOG4J
 (AUDIT_LOG4J_GUID)
 TABLESPACE ADAPTER_INDEX01;

DELETE FROM ADAPTER.TRANSLATIONS
WHERE TRANSLATION_ID IN (
    SELECT 
        MAX(T.TRANSLATION_ID) AS Translation_id
    FROM 
        ADAPTER.TRANSLATIONS T 
    GROUP BY 
        T.SOURCE_CODESET, T.SOURCE_CODE, T.TARGET_CODESET
    HAVING
        COUNT(*) > 1
);
 
 CREATE UNIQUE INDEX ADAPTER.TRANSLATIONS_SRC_DEST_CDE_UK ON ADAPTER.TRANSLATIONS
 (SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET)
 TABLESPACE ADAPTER_INDEX01;

GRANT SELECT ON ADAPTER.AUDIT_LOG4J TO ADAPTER_READ;
GRANT SELECT ON ADAPTER.AUDIT_LOG4J TO CDW_READ;
GRANT SELECT, UPDATE, INSERT, DELETE ON ADAPTER.AUDIT_LOG4J TO ADAPTER_USER;

CREATE PUBLIC SYNONYM AUDIT_LOG4J FOR ADAPTER.AUDIT_LOG4J;

INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '01', 'CVX_GROUP', '01,107', 'DTP');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '02', 'CVX_GROUP', '02,89', 'OPV');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '03', 'CVX_GROUP', '03,03', 'MMR');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '04', 'CVX_GROUP', '04,03', 'M/R');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '05', 'CVX_GROUP', '05,03', 'measles');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '06', 'CVX_GROUP', '06,03', 'rubella');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '07', 'CVX_GROUP', '07,03', 'mumps');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '08', 'CVX_GROUP', '08,45', 'Hep B, adolescent or pediatric');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '09', 'CVX_GROUP', '09,139', 'Td(adult), 2 Lf tetanus toxoid, preservative free, adsorbed');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '10', 'CVX_GROUP', '10,89', 'IPV');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '15', 'CVX_GROUP', '15,88', 'influenza, split (incl. purified surface antigen');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '16', 'CVX_GROUP', '16,88', 'influenze, whole');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '17', 'CVX_GROUP', '17,17', 'Hib, unspecified formulation');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '18', 'CVX_GROUP', '18,90', 'rabies, intramuscular injection');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '19', 'CVX_GROUP', '19,19', 'BCG');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '20', 'CVX_GROUP', '20,107', 'DTaP');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '21', 'CVX_GROUP', '21,21', 'varicella');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '22', 'CVX_GROUP', '22,17,107', 'DTP-Hib');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '23', 'CVX_GROUP', '23,23', 'plague');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '24', 'CVX_GROUP', '24,24', 'anthrax');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '25', 'CVX_GROUP', '25,91', 'typhoid, oral');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '26', 'CVX_GROUP', '26,26', 'cholera, unspecified formulation');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '28', 'CVX_GROUP', '28,107', 'DT (pediatric)');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '31', 'CVX_GROUP', '31,85', 'Hep A, pediatric, unspecified formulation');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '32', 'CVX_GROUP', '32,108', 'meningococcal MPSV4');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '33', 'CVX_GROUP', '33,33', 'pneumococcal polysaccharide PPV23');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '37', 'CVX_GROUP', '37,184', 'yellow fever');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '38', 'CVX_GROUP', '38,03', 'rubella/mumps');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '39', 'CVX_GROUP', '39,129', 'Japanese encephalitis SC');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '40', 'CVX_GROUP', '40,90', 'rabies, intradermal injection');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '41', 'CVX_GROUP', '41,91', 'typhoid, parenteral');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '42', 'CVX_GROUP', '42,45', 'Hep B, adolescent/high risk infant');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '43', 'CVX_GROUP', '43,45', 'Hep B, adult');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '44', 'CVX_GROUP', '44,45', 'Hep B, dialysis');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '45', 'CVX_GROUP', '45,45', 'Hep B, unspecified formulation');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '46', 'CVX_GROUP', '46,17', 'Hib (PRP-D)');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '47', 'CVX_GROUP', '47,17', 'Hib (HbOC)');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '48', 'CVX_GROUP', '48,17', 'Hib (PRP-T)');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '49', 'CVX_GROUP', '49,17', 'Hib (PRP-OMP)');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '50', 'CVX_GROUP', '50,17,107', 'DTaP-Hib');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '51', 'CVX_GROUP', '51,17,45', 'Hib-Hep B');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '52', 'CVX_GROUP', '52,85', 'Hep A, adult');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '53', 'CVX_GROUP', '53,91', 'typhoid, parenteral, AKD (U.S. military)');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '54', 'CVX_GROUP', '54,82', 'adenovirus, type 4');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '55', 'CVX_GROUP', '55,82', 'adenovirus, type 7');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '58', 'CVX_GROUP', '58,58', 'Hep C');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '59', 'CVX_GROUP', '59,59', 'Hep E');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '62', 'CVX_GROUP', '62,137', 'HPV, quadrivalent');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '66', 'CVX_GROUP', '66,66', 'Lyme disease');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '74', 'CVX_GROUP', '74,122', 'rotavirus, tetravalent');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '75', 'CVX_GROUP', '75,75', 'vaccinia (smallpox)');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '80', 'CVX_GROUP', '80,92', 'VEE, live');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '81', 'CVX_GROUP', '81,92', 'VEE, inactivated');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '82', 'CVX_GROUP', '82,82', 'adenovirus, unspecified formulation');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '83', 'CVX_GROUP', '83,85', 'Hep A, ped/adol, 2 dose');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '84', 'CVX_GROUP', '84,85', 'Hep A, ped/adol, 3 dose');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '85', 'CVX_GROUP', '85,85', 'Hep A, unspecified formulation');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '88', 'CVX_GROUP', '88,88', 'influenza, unspecified formulation');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '89', 'CVX_GROUP', '89,89', 'polio, unspecified formulation');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '90', 'CVX_GROUP', '90,90', 'rabies, unspecified formulation');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '91', 'CVX_GROUP', '91,91', 'typhoid, unspecified formulation');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '92', 'CVX_GROUP', '92,92', 'VEE, unspecified formulation');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '94', 'CVX_GROUP', '94,21,03', 'MMRV');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '100', 'CVX_GROUP', '100,152', 'pneumococcal conjugate PCV 7');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '101', 'CVX_GROUP', '101,91', 'typhoid, ViCPs');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '102', 'CVX_GROUP', '102,17,45,107', 'DTP-Hib-Hep B');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '103', 'CVX_GROUP', '103,108', 'meningococcal C conjugate');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '104', 'CVX_GROUP', '104,85,45', 'Hep A-Hep B');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '105', 'CVX_GROUP', '105,75', 'vaccinia (smallpox) diluted');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '106', 'CVX_GROUP', '106,107', 'DTaP, 5 pertussis antigens');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '107', 'CVX_GROUP', '107,107', 'DTaP, unspecified formulation');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '108', 'CVX_GROUP', '108,108', 'meningococcal ACWY, unspecified formulation');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '110', 'CVX_GROUP', '110,45,89,107', 'DTaP-Hep B-IPV');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '111', 'CVX_GROUP', '111,88', 'influenza, live, intranasal');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '113', 'CVX_GROUP', '113,139', 'Td (adult), 5 Lf tetanus toxoid, preservative free, adsorbed');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '114', 'CVX_GROUP', '114,108', 'meningococcal MCV4P');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '115', 'CVX_GROUP', '115,115', 'Tdap');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '116', 'CVX_GROUP', '116,122', 'rotavirus, pentavalent');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '118', 'CVX_GROUP', '118,137', 'HPV, bivalent');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '119', 'CVX_GROUP', '119,122', 'rotavirus, monovalent');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '120', 'CVX_GROUP', '120,89,17,107', 'DTaP-Hib-IPV');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '121', 'CVX_GROUP', '121,188', 'zoster live');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '122', 'CVX_GROUP', '122,122', 'rotavirus, unspecified formulation');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '123', 'CVX_GROUP', '123,123', 'influenza, H5N1-1203');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '125', 'CVX_GROUP', '125,128', 'Novel Influenza-H1N1-09, nasal');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '126', 'CVX_GROUP', '126,128', 'Novel Influenza-H1N1-09, preservative free');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '127', 'CVX_GROUP', '127,128', 'Novel Influenza-H1N1-09');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '128', 'CVX_GROUP', '128,128', 'Novel Influenza-H1N1-09, all formulations');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '129', 'CVX_GROUP', '129,129', 'Japanese Encephalitis, unspecified formulation');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '130', 'CVX_GROUP', '130,89,107', 'DTaP-IPV');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '132', 'CVX_GROUP', '132,17,107,45,89', 'DTaP-IPV-HIB-HEP B, historical');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '133', 'CVX_GROUP', '133,152', 'Pneumococcal conjugate PCV 13');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '134', 'CVX_GROUP', '134,129', 'Japanese Encephalitis IM');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '135', 'CVX_GROUP', '135,88', 'Influeza, high dose seasonal');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '136', 'CVX_GROUP', '136,108', 'Meningococcal MCV40');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '137', 'CVX_GROUP', '137,137', 'HPV, unspecified formulation');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '138', 'CVX_GROUP', '138,139', 'Td (adult)');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '139', 'CVX_GROUP', '139,139', 'Td (adult) unspecified formulation');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '140', 'CVX_GROUP', '140,88', 'Influeza, seasonal, injectable, preservative free');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '141', 'CVX_GROUP', '141,88', 'Influenza, seasonal, injectable');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '143', 'CVX_GROUP', '143,82', 'Adenovirus types 4 and 7');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '144', 'CVX_GROUP', '144,88', 'influenze, seasonal, intradermal, preservative free');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '146', 'CVX_GROUP', '146,17,45,89,107', 'DTaP,IPV,Hib,HepB');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '147', 'CVX_GROUP', '147,108', 'meningococcal MCV4, unspecified formulation');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '148', 'CVX_GROUP', '148,17,108', 'Meningococcal C/Y-HIB PRP');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '149', 'CVX_GROUP', '149,88', 'influenza, live, intranasal, quadrivalent');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '150', 'CVX_GROUP', '150,88', 'influenza, injectable, quadrivalent, preservative free');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '151', 'CVX_GROUP', '151,88', 'influenza nasal, unspecified formulation');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '152', 'CVX_GROUP', '152,152', 'Pneumococcal Conjugate, unspecified formulation');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '153', 'CVX_GROUP', '153,88', 'Influenza, injectable, MDCK, preservative free');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '155', 'CVX_GROUP', '155,88', 'influenza, recombinant, injectable, preservative free');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '158', 'CVX_GROUP', '158,88', 'influenza, injectable, quadrivalent');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '160', 'CVX_GROUP', '160,123', 'Influenza A monovalent (H5N1), ADJUVANTED-2013');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '161', 'CVX_GROUP', '161,88', 'Influenza, injectable,quadrivalent, preservative free, pediatric');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '162', 'CVX_GROUP', '162,164', 'meningococcal B, recombinan');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '163', 'CVX_GROUP', '163,164', 'meningococcal B, OMV');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '164', 'CVX_GROUP', '164,164', 'meningococcal B, unspecified');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '165', 'CVX_GROUP', '165,137', 'HPV9');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '166', 'CVX_GROUP', '166,88', 'influenza, intradermal, quadrivalent, preservative free');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '168', 'CVX_GROUP', '168,88', 'influenza, trivalent, adjuvanted');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '170', 'CVX_GROUP', '170,89,107,17', 'DTAP/IPV/HIB - non-US');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '171', 'CVX_GROUP', '171,88', 'Influenza, injectable, MDCK, preservative free, quadrivalent');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '172', 'CVX_GROUP', '172,26', 'cholera, WC-rBS');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '173', 'CVX_GROUP', '173,26', 'cholera, BivWC');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '174', 'CVX_GROUP', '174,26', 'cholera, live attenuated');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '175', 'CVX_GROUP', '175,90', 'Rabies - IM Diploid cell culture');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '176', 'CVX_GROUP', '176,90', 'Rabies - IM fibroblast culture');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '177', 'CVX_GROUP', '177,152', 'PCV10');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '183', 'CVX_GROUP', '183,184', 'Yellow fever vaccine - alt');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '184', 'CVX_GROUP', '184,184', 'Yellow fever, unspecified formulation');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '185', 'CVX_GROUP', '185,88', 'influenza, recombinant, quadrivalent,injectable, preservative free');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '186', 'CVX_GROUP', '186,88', 'Influenza, injectable, MDCK, quadrivalent, preservative');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '187', 'CVX_GROUP', '187,188', 'zoster subunit');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '188', 'CVX_GROUP', '188,188', 'zoster, unspecified formulation');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'CVX', '189', 'CVX_GROUP', '189,45', 'Hep B, adjuvanted');
INSERT INTO 
  ADAPTER.CODESETS (CODESET_ID, CODESET, LOOKUP_TABLE, KEY_FIELD)
VALUES 
  (ADAPTER.CODESET_ID_SEQ.NEXTVAL, 'CVX_GROUP', 'TRANSLATIONS', 'TARGET_CODE');
commit;

Set Define on;

Begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :end_date from dual;
  dbms_output.put_line('Script end date/time:    '||:end_date);
  dbms_output.put_line('Script executed in '||(to_date(:end_date, 'mm_dd_yyyy hh24:mi:ss') - to_date(:start_date, 'mm-dd-yyyy hh24:mi:ss')) *24*60*60||' seconds');
end;
/

Spool off;
