set echo on
set feedback on
set serveroutput on
var start_date  varchar2(80);
var end_date    varchar2(80);
var sid         varchar2(10);
var host        varchar2(30);
var user        varchar2(30);


spool 8.0.1_Update_Script.log;

begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :start_date from dual;
  select instance_name into :sid from v$instance;
  select host_name into :host from v$instance;
  select user into :user from dual;

  dbms_output.put_line('Script executed on SID:  '||:sid);
  dbms_output.put_line('Script executed on host: '||:host);
  dbms_output.put_line('Script start date/time:  '||:start_date);
  dbms_output.put_line('Script executed by:      '||:user);
end;
/
SET DEFINE OFF;


-- these changes cannot be backed out.  They're meant to fix a bug in production that we don't want to keep.
-- Fix Updates for CCM-235: Updates radiology hold_period to include referenceDateTime -- 
UPDATE ADAPTER.INT_FAC_FILT SET OBJ_NAME = 'signingClinician.dateTime' WHERE ROOT_NAME = 'radiologies' AND FILTER_ID = 8 AND FACILITY_ID = 1;
-- end fix Updates for CCM-235.

-- reinsert duplicate 
insert into ADAPTER.INT_FAC_FILT(FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM)
values (1, 7, 'radiologies', 'signingClinician.dateTime,referenceDateTime', 3);
-- end 

commit;

Set Define on;

Begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :end_date from dual;
  dbms_output.put_line('Script end date/time:    '||:end_date);
  dbms_output.put_line('Script executed in '||(to_date(:end_date, 'mm_dd_yyyy hh24:mi:ss') - to_date(:start_date, 'mm-dd-yyyy hh24:mi:ss')) *24*60*60||' seconds');
end;
/

Spool off;
