set echo on
set feedback on
set serveroutput on
var start_date  varchar2(80);
var end_date    varchar2(80);
var sid         varchar2(10);
var host        varchar2(30);
var user        varchar2(30);


spool 8.0.0_Update_Script_Backout.log;

begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :start_date from dual;
  select instance_name into :sid from v$instance;
  select host_name into :host from v$instance;
  select user into :user from dual;

  dbms_output.put_line('Script executed on SID:  '||:sid);
  dbms_output.put_line('Script executed on host: '||:host);
  dbms_output.put_line('Script start date/time:  '||:start_date);
  dbms_output.put_line('Script executed by:      '||:user);
end;
/

SET DEFINE OFF;

DROP PUBLIC SYNONYM BINARIES;
DROP PUBLIC SYNONYM DOCUMENT_REFERENCES;
DROP PUBLIC SYNONYM SUBSCRIPTIONS;
DROP PUBLIC SYNONYM BINARY_ID_SEQ;
DROP PUBLIC SYNONYM DOCUMENT_REFERENCE_ID_SEQ;
DROP PUBLIC SYNONYM SUBSCRIPTION_ID_SEQ;

DROP TABLE ADAPTER.BINARIES;
DROP TABLE ADAPTER.DOCUMENT_REFERENCES;
DROP TABLE ADAPTER.SUBSCRIPTIONS;

DROP SEQUENCE ADAPTER.BINARY_ID_SEQ;
DROP SEQUENCE ADAPTER.DOCUMENT_REFERENCE_ID_SEQ;
DROP SEQUENCE ADAPTER.SUBSCRIPTION_ID_SEQ;

-- Backout for CCM-196.
ALTER TABLE ADAPTER.CACHE DROP COLUMN DATE_CREATED;
-- end Backout for CCM-196.

-- Backout for CCM-235: Backout radiology hold_period to exclude referenceDateTime -- 
UPDATE ADAPTER.INT_FAC_FILT SET OBJ_NAME = 'signingClinician.dateTime' WHERE ROOT_NAME = 'radiologies' AND FACILITY_ID = 1;
-- end Updates for CCM-235.

-- Backout for CCM-258.
-- remove 3 day hold to mhv based visits documents
DELETE FROM ADAPTER.INT_FAC_FILT WHERE FACILITY_ID=1 AND FILTER_ID=7 AND ROOT_NAME='visits.documents' AND OBJ_NAME='signingClinician.dateTime' AND PARAM=3;
DELETE FROM ADAPTER.INT_FAC_FILT WHERE FACILITY_ID=1 AND FILTER_ID=5 AND ROOT_NAME='visits.documents' AND OBJ_NAME='signingClinician.dateTime' AND PARAM='0313101';
UPDATE ADAPTER.INT_FAC_FILT SET ROOT_NAME = 'visits', PARAM = '5' WHERE ROOT_NAME = 'visits.documents' AND OBJ_NAME IS NULL AND FILTER_ID = 8 AND FACILITY_ID = 1;
-- end Backout for CCM-258.

-- Backout CCDA r2.1
declare
  LAST_VA_TYPE_ID ADAPTER.VA_TYPES.VA_TYPE_ID%TYPE;
begin
  SELECT VA_TYPE_ID INTO LAST_VA_TYPE_ID FROM ADAPTER.VA_TYPES WHERE QUERYNAME='34133-9-C2';
  DELETE FROM ADAPTER.FACILITY_SUPPORTED_TYPES WHERE VA_TYPE_ID = LAST_VA_TYPE_ID;
  DELETE FROM ADAPTER.VA_TYPES WHERE QUERYNAME='34133-9-C2';
end;
/
-- end Backout CCDA r2.1

commit;

Set Define on;

Begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :end_date from dual;
  dbms_output.put_line('Script end date/time:    '||:end_date);
  dbms_output.put_line('Script executed in '||(to_date(:end_date, 'mm_dd_yyyy hh24:mi:ss') - to_date(:start_date, 'mm-dd-yyyy hh24:mi:ss')) *24*60*60||' seconds');
end;
/

Spool off;
