-- Must use a user that has SYSTEM privileges (like SYSTEM user)
CREATE ROLE CDW_READ;
GRANT CREATE SESSION TO CDW_READ;
GRANT SELECT ON adapter.audits_report TO CDW_READ;

CREATE USER CDW_ETL
  IDENTIFIED BY isdke9kk13__sd;
  DEFAULT TABLESPACE USERS
  TEMPORARY TABLESPACE TEMP
  PROFILE SERVICE_ACCOUNT
  ACCOUNT UNLOCK;
  -- 1 Role for CDW_ETL 
  GRANT CDW_READ TO CDW_ETL;
  ALTER USER CDW_ETL DEFAULT ROLE ALL;



CREATE OR REPLACE VIEW "VAP"."CDW_VISN"(
 "ID", 
 "VISN_NUMBER", 
 "VISN_NAME" 
) 
AS SELECT 
  "ID", 
  "VISN_NUMBER", 
  "VISN_NAME"
FROM
  "VAP"."VISN";

CREATE OR REPLACE VIEW "VAP"."CDW_FACILITY"(
  "FACILITY_ID", 
	"FACILITY_STATION", 
	"FACILITY_DNS", 
	"FACILITY_NAME", 
	"ALLOWED", 
	"VISN_ID", 
	"FACILITY_PHONE", 
	"FACILITY_ADDRESS", 
	"FACILITY_CITY", 
	"FACILITY_STATE", 
	"FACILITY_POSTAL_CODE", 
	"FACILITY_PARENT", 
	"ACTIVE"
)
AS SELECT
  "FACILITY_ID", 
	"FACILITY_STATION", 
	"FACILITY_DNS", 
	"FACILITY_NAME", 
	"ALLOWED", 
	"VISN_ID", 
	"FACILITY_PHONE", 
	"FACILITY_ADDRESS", 
	"FACILITY_CITY", 
	"FACILITY_STATE", 
	"FACILITY_POSTAL_CODE", 
	"FACILITY_PARENT", 
	"ACTIVE"
FROM "VAP".FACILITY;

CREATE OR REPLACE VIEW "VAP"."CDW_CONSENT_AUDIT"(
	"CONSENT_AUDIT_ID", 
	"ACTION_TYPE",
	"CONSENT_TYPE",
	"CREATED_DATE",
	"DETAIL",
	"FACILITY",
	"FACILITY_NAME",
	"OPTOUT_REASON",
	"PATIENT_GIVEN_NAME",
	"PATIENT_ID",
	"PATIENT_LAST_NAME",
	"PATIENT_SSN",
	"POU_VALUE",
	"TIME_OF_EVENT",
	"USER_ID",
	"PATIENT_MIDDLE_NAME"
)
AS SELECT
	"CONSENT_AUDIT_ID", 
	"ACTION_TYPE",
	"CONSENT_TYPE",
	"CREATED_DATE",
	"DETAIL",
	"FACILITY",
	"FACILITY_NAME",
	"OPTOUT_REASON",
	"PATIENT_GIVEN_NAME",
	"PATIENT_ID",
	"PATIENT_LAST_NAME",
	"PATIENT_SSN",
	"POU_VALUE",
	"TIME_OF_EVENT",
	"USER_ID",
	"PATIENT_MIDDLE_NAME"
FROM
  "VAP"."CONSENT_AUDIT";

CREATE OR REPLACE VIEW "VAP"."CDW_DELAYED_CONSENT" (
	"DELAYED_CONSENT_ID",
	"PATIENT_IEN",
	"PATIENT_SSN",
	"PATIENT_LAST_NAME",
	"PATIENT_FIRST_NAME",
	"PATIENT_MIDDLE_NAME",
	"DATE_ADDED",
	"USER_ID",
	"STATION_NUMBER",
	"CONSENT_TYPE_ID",
	"STATUS",
	"RESOLUTION_DATE"
)
AS SELECT
	"DELAYED_CONSENT_ID",
	"PATIENT_IEN",
	"PATIENT_SSN",
	"PATIENT_LAST_NAME",
	"PATIENT_FIRST_NAME",
	"PATIENT_MIDDLE_NAME",
	"DATE_ADDED",
	"USER_ID",
	"STATION_NUMBER",
	"CONSENT_TYPE_ID",
	"STATUS",
	"RESOLUTION_DATE"
FROM
  "VAP"."DELAYED_CONSENT";

CREATE OR REPLACE VIEW "VAP"."CDW_PATIENT_CONSENT_DIR" (
	"CONSENT_DIR_ID",
	"EXPIRATION_DATE",
	"OPTIN_DATE",
	"OPTIN_TS",
	"OPTOUT_DATE",
	"OPTOUT_TS",
	"PATIENT_IEN",
	"OPTIN_CONSENT_TYPE_ID",
	"OPTOUT_CONSENT_TYPE_ID",
	"OPTOUT_REASON_ID",
	"POU_ID"
)
AS SELECT
	"CONSENT_DIR_ID",
	"EXPIRATION_DATE",
	"OPTIN_DATE",
	"OPTIN_TS",
	"OPTOUT_DATE",
	"OPTOUT_TS",
	"PATIENT_IEN",
	"OPTIN_CONSENT_TYPE_ID",
	"OPTOUT_CONSENT_TYPE_ID",
	"OPTOUT_REASON_ID",
	"POU_ID"
FROM
	"VAP"."PATIENT_CONSENT_DIR";
	
	
GRANT SELECT ON "VAP"."CDW_VISN" TO CDW_READ;
GRANT SELECT ON "VAP"."CDW_FACILITY" TO CDW_READ;
GRANT SELECT ON "VAP"."CDW_CONSENT_AUDIT" TO CDW_READ;
GRANT SELECT ON "VAP"."CDW_DELAYED_CONSENT" TO CDW_READ;
GRANT SELECT ON "VAP"."CDW_PATIENT_CONSENT_DIR" TO CDW_READ;