set echo on
set feedback on
set serveroutput on
var start_date  varchar2(80);
var end_date    varchar2(80);
var sid         varchar2(10);
var host        varchar2(30);
var user        varchar2(30);


spool 7.2.0_Update_Script.log;

begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :start_date from dual;
  select instance_name into :sid from v$instance;
  select host_name into :host from v$instance;
  select user into :user from dual;

  dbms_output.put_line('Script executed on SID:  '||:sid);
  dbms_output.put_line('Script executed on host: '||:host);
  dbms_output.put_line('Script start date/time:  '||:start_date);
  dbms_output.put_line('Script executed by:      '||:user);
end;
/
SET DEFINE OFF;

-- US.06.04.01 - Store consumer system ID separately from the user ID in the audit table
ALTER TABLE ADAPTER.AUDITS 
    ADD SYSTEM_ID    VARCHAR2(255 BYTE);

CREATE OR REPLACE FORCE VIEW ADAPTER.AUDITS_REPORT
(
   AUDIT_ID,
   ACTION_NAME,
   USER_ID,
   SYSTEM_ID,
   ORGANIZATION_ID,
   PATIENT_ID,
   PURPOSE_FOR_USE,
   DOCUMENT_ID,
   AUDIT_TIME,
   OPTOUT_REASON_ID,
   REMOTE_ORGANIZATION_ID,
   REMOTE_DOC_REPOSITORY_ID,
   REMOTE_DOC_ID,
   CLASS_CODE, 
   TITLE, 
   RAW_DATA_SIZE,
   DETAILS,
   PATIENT_LAST_NAME,
   PATIENT_MIDDLE_NAME,
   PATIENT_GIVEN_NAME,
   MOTHER_MAIDEN_NAME,
   POB_CITY,
   POB_STATE,
   USER_NAME,
   PATIENT_FACILITY_NUMBER,
   PATIENT_SSN,
   PATIENT_FACILITY_NAME,
   USER_FACILITY_NUMBER,
   USER_FACILITY_NAME,
   ORGANIZATION_NAME,
   REMOTE_ORGANIZATION_NAME,
   OPTOUT_REASON_TEXT,
   DOCUMENT_TITLE,
   DOCUMENT_SOURCE_PATIENT_ID,
   USER_ROLE,
   DOC_SPEC_TYPE,
   PATIENT_SSN_EX,
   MATCH_FOUND,
   MATCH_FAILED,
   IS_TEST_PATIENT,
   HIE_TRANSACTION_ID
)
AS
   SELECT b.AUDIT_ID,
          b.ACTION_NAME,
          b.USER_ID,
          b.SYSTEM_ID,
          b.ORGANIZATION_ID,
          b.PATIENT_ID,
          b.PURPOSE_FOR_USE,
          b.DOCUMENT_ID,
          b.AUDIT_TIME,
          b.OPTOUT_REASON_ID,
          b.REMOTE_ORGANIZATION_ID,
          b.REMOTE_DOC_REPOSITORY_ID,
          b.REMOTE_DOC_ID,
          b.CLASS_CODE, 
          b.TITLE, 
          b.RAW_DATA_SIZE,
          b.DETAILS,
          b.PATIENT_LAST_NAME,
          b.PATIENT_MIDDLE_NAME,
          b.PATIENT_GIVEN_NAME,
          b.MOTHER_MAIDEN_NAME,
          b.POB_CITY,
          b.POB_STATE,
          b.USER_NAME,
          b.PATIENT_FACILITY_NUMBER,
          b.PATIENT_SSN,
          b.PATIENT_FACILITY_NAME,
          b.USER_FACILITY_NUMBER,
          b.USER_FACILITY_NAME,
          b.ORGANIZATION_NAME,
          b.REMOTE_ORGANIZATION_NAME,
          b.OPTOUT_REASON_TEXT,
          b.DOCUMENT_TITLE,
          b.DOCUMENT_SOURCE_PATIENT_ID,
          b.USER_ROLE,
          b.DOC_SPEC_TYPE,
          b.PATIENT_SSN_EX,
          b.MATCH_FOUND,
          b.MATCH_FAILED,
          (CASE
              WHEN b.PATIENT_SSN_EX IS NULL
              THEN
                 0                   /* Null entries aren't considered test */
              WHEN    SUBSTR (b.PATIENT_SSN_EX, 1, 3) = '000'
                   OR                          /* Area number cannot be 000 */
                     SUBSTR (b.PATIENT_SSN_EX, 1, 3) = '666'
                   OR                          /* Area number cannot be 666 */
                     SUBSTR (b.PATIENT_SSN_EX, 1, 1) = '9'
                   OR             /* Area number cannot be in 900-999 range */
                     SUBSTR (b.PATIENT_SSN_EX, 4, 2) = '00'
                   OR                          /* Group number cannot be 00 */
                     SUBSTR (b.PATIENT_SSN_EX, 6, 4) = '0000' /* Serial number cannot be 0000 */
              THEN
                 1
              ELSE
                 0
           END)
             IS_TEST_PATIENT,
          b.HIE_TRANSACTION_ID
     FROM (SELECT a.AUDIT_ID,
                  a.ACTION_NAME,
                  UPPER (a.USER_ID) USER_ID,
                  a.SYSTEM_ID,
                  a.ORGANIZATION_ID,
                  UPPER (a.PATIENT_ID) PATIENT_ID,
                  a.PURPOSE_FOR_USE,
                  a.DOCUMENT_ID,
                  a.AUDIT_TIME,
                  a.OPTOUT_REASON_ID,
                  a.REMOTE_ORGANIZATION_ID,
                  a.REMOTE_DOC_REPOSITORY_ID,
                  a.REMOTE_DOC_ID,
                  d.CLASS_CODE, 
                  d.TITLE, 
                  d.RAW_DATA_SIZE,
                  UPPER (a.DETAILS) DETAILS,
                  UPPER (a.PATIENT_LAST_NAME) PATIENT_LAST_NAME,
                  UPPER (a.PATIENT_MIDDLE_NAME) PATIENT_MIDDLE_NAME,
                  UPPER (a.PATIENT_GIVEN_NAME) PATIENT_GIVEN_NAME,
                  UPPER (a.MOTHER_MAIDEN_NAME) MOTHER_MAIDEN_NAME,
                  UPPER (a.POB_CITY) POB_CITY,
                  UPPER (a.POB_STATE) POB_STATE,
                  UPPER (a.USER_NAME) USER_NAME,
                  a.PATIENT_FACILITY_NUMBER,
                  a.PATIENT_SSN,
                  UPPER (a.PATIENT_FACILITY_NAME) PATIENT_FACILITY_NAME,
                  a.USER_FACILITY_NUMBER,
                  UPPER (a.USER_FACILITY_NAME) USER_FACILITY_NAME,
                  UPPER (f1.FACILITY_NAME) ORGANIZATION_NAME,
                  UPPER (f2.FACILITY_NAME) REMOTE_ORGANIZATION_NAME,
                  opt.TEXT OPTOUT_REASON_TEXT,
                  UPPER (d.TITLE) DOCUMENT_TITLE,
                  d.SOURCE_PATIENT_ID DOCUMENT_SOURCE_PATIENT_ID,
                  a.USER_ROLE,
                  a.DOC_SPEC_TYPE,
                  (CASE
                      WHEN a.PATIENT_SSN IS NOT NULL
                      THEN
                         a.PATIENT_SSN
                      WHEN INSTR (a.DETAILS, 'ssn=') > 0
                      THEN
                         SUBSTR (
                            REPLACE (
                               REGEXP_SUBSTR (a.DETAILS, 'ssn=([^,]+)'),
                               '-',
                               ''),
                            5)
                   END)
                     PATIENT_SSN_EX,
                  (CASE
                      WHEN INSTR (a.details, 'MATCH FOUND') = 1 THEN 1
                      ELSE 0
                   END)
                     MATCH_FOUND,
                  (CASE
                      WHEN INSTR (a.details, 'MATCH FAILED') = 1 THEN 1
                      ELSE 0
                   END)
                     MATCH_FAILED,
                  a.HIE_TRANSACTION_ID
             FROM AUDITS a
                  LEFT OUTER JOIN FACILITIES f1
                     ON a.ORGANIZATION_ID = f1.FULL_HOME_COMMUNITY_ID
                  LEFT OUTER JOIN FACILITIES f2
                     ON a.REMOTE_ORGANIZATION_ID = f2.FULL_HOME_COMMUNITY_ID
                  LEFT OUTER JOIN OPTOUT_REASONS opt
                     ON a.OPTOUT_REASON_ID = opt.OPTOUT_REASON_ID
                  LEFT OUTER JOIN DOCUMENTS d
                     ON a.DOCUMENT_ID = d.DOCUMENT_UNIQUE_ID) b;
-- end US.06.04.01 - Store consumer system ID separately from the user ID in the audit table

-- US.06.01.03 - Track chain of audit records using a Transaction ID
ALTER TABLE ADAPTER.AUDITS MODIFY( HIE_TRANSACTION_ID VARCHAR2(36) );
-- end US.06.01.03 - Track chain of audit records using a Transaction ID

-- US.12.01.12 Add All Consult Notes logic to Small C-CDA
update ADAPTER.int_fac_filt set param = 500 where filter_id = 8 and facility_id = 1 and root_name = 'consultnotes';
-- end US.12.01.12 Add All Consult Notes logic to Small C-CDA

-- US.12.01.13 Add Clinical Procedures Notes logic to Small C-CDA
update ADAPTER.int_fac_filt set param = 500 where filter_id = 8 and facility_id = 1 and root_name = 'clinicalProcedureNotes';
-- end US.12.01.13 Add Clinical Procedures Notes logic to Small C-CDA

-- US.12.01.23 Add Encounters (H&P Notes) logic to Small C-CDA
update ADAPTER.int_fac_filt set param = 500 where filter_id = 8 and facility_id = 1 and root_name = 'historyphysicalnotes';
-- end US.12.01.23 Add Encounters (H&P Notes) logic to Small C-CDA

-- US.12.01.24 Add Encounters (Discharge Summary) logic to Small C-CDA
update ADAPTER.int_fac_filt set param = 500 where filter_id = 8 and facility_id = 1 and root_name = 'dischargeSummaries';
-- end US.12.01.24 Add Encounters (Discharge Summary) logic to Small C-CDA


commit;

Set Define on;

Begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :end_date from dual;
  dbms_output.put_line('Script end date/time:    '||:end_date);
  dbms_output.put_line('Script executed in '||(to_date(:end_date, 'mm_dd_yyyy hh24:mi:ss') - to_date(:start_date, 'mm-dd-yyyy hh24:mi:ss')) *24*60*60||' seconds');
end;
/

Spool off;
