package gov.va.med.nhin.adapter.utils;

import java.io.Closeable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Statement;

import org.slf4j.Logger;

public class DatabaseUtils
{
   public static void closeConnection(Connection conn, Logger logger)
   {
      if(conn == null)
      {
         return;
      }
      
      try
      {
         conn.close();
      }
      catch(Exception ex)
      {
         if(logger != null)
         {
            logger.warn("An exception occurred while closing a database connection.", ex);
         }
      }
   }
   
   public static void closeStatement(Statement stmt, Logger logger)
   {
      if(stmt == null)
      {
         return;
      }
      
      try
      {
         stmt.close();
      }
      catch(Exception ex)
      {
         if(logger != null)
         {
            logger.warn("An exception occurred while closing a database statement.", ex);
         }
      }
   }

   public static void closeIO(Closeable toClose, Logger logger)
   {
      if(toClose == null)
      {
         return;
      }
      
      try
      {
         toClose.close();
      }
      catch(Exception ex)
      {
         if(logger != null)
         {
            logger.warn("An exception occurred while closing an IO resource.", ex);
         }
      }
   }
   
   /*
    This method frees the Blob object and releases the resources that it holds. 
    The object is invalid once the free method is called. 
    After free has been called, any attempt to invoke a method other than
    free will result in a SQLException being thrown. If free is called multiple times, 
    the subsequent calls to free are treated as a no-op.
   */
    public static void closeBlob(Blob blob, Logger logger)
   {
      if(blob == null)
      {
         return;
      }
      
      try
      {
         blob.free();
      }
      catch(Exception ex)
      {
         if(logger != null)
         {
            logger.warn("An exception occurred while closing an IO resource opened for BLOB object.", ex);
         }
      }
   }
}
