
package gov.va.med.nhin.adapter.subscription.web.utils.logging;

import java.io.InvalidClassException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.MDC;

/**
 *
 * @author Jay Ward<jay@paladinarcher.com>
 */
public final class Log {
    public static final String CORRELATION_MDCKEY = "correlationId";
    public static Object GetMDC() {
        String ret;
        try {
            ret = MDC.get(CORRELATION_MDCKEY);
            if(ret == null) { throw new NullPointerException(); }
            if(!(ret instanceof String)) { throw new InvalidClassException("That key isn't a String."); }
        } catch (Exception e) {
            ret = UUID.randomUUID().toString();
            MDC.put(CORRELATION_MDCKEY, ret);
        }
        return ret;
    }
    public static void info(Logger logger, String message) {
        GetMDC();
        logger.info(message);
    }
    public static void debug(Logger logger, String message) {
        GetMDC();
        logger.debug(message);
    }
    public static void warn(Logger logger, String message) {
        GetMDC();
        logger.warn(message);
    }
    public static void error(Logger logger, String message) {
        GetMDC();
        logger.error(message);
    }
}
