package gov.va.med.nhin.adapter.subscription.web.utils;

import gov.va.med.nhin.adapter.subscription.web.annotations.Property;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.enterprise.context.Dependent;
import javax.inject.Named;

@Named("PropertyProducer")
@Dependent()
public class PropertyProducer
{
    private Properties properties;

    @Property
    @Produces
    public String produceString(final InjectionPoint ip)
    {
        return this.properties.getProperty(getKey(ip), getDefaultValue(ip));
    }

    @Property
    @Produces
    public int produceInt(final InjectionPoint ip)
    {
        return Integer.valueOf(this.properties.getProperty(getKey(ip), getDefaultValue(ip)));
    }

    @Property
    @Produces
    public boolean produceBoolean(final InjectionPoint ip)
    {
        return Boolean.valueOf(this.properties.getProperty(getKey(ip), getDefaultValue(ip)));
    }

    private String getKey(final InjectionPoint ip)
    {
        return ip.getAnnotated().isAnnotationPresent(Property.class)
            && !ip.getAnnotated().getAnnotation(Property.class).value().isEmpty()
            ? ip.getAnnotated().getAnnotation(Property.class).value() : ip.getMember().getName();
    }

    private String getDefaultValue(final InjectionPoint ip)
    {
        return ip.getAnnotated().isAnnotationPresent(Property.class)
               && !ip.getAnnotated().getAnnotation(Property.class).defaultValue().isEmpty()
               ? ip.getAnnotated().getAnnotation(Property.class).defaultValue() : null;
    }
    
    @PostConstruct
    public void init()
    {
        this.properties = new Properties();
        //final InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("adapter-subscription.properties");
        //if (stream == null) {
        //    throw new RuntimeException("No properties!!!");
        //}

        //new feature implemented. 'try - with - resources' to close the stream.
        //Supported from java ver 7 onwards
        /**
         * The try-with-resources statement ensures that each resource is closed at the end of the statement. 
         * Any object that implements java.lang.AutoCloseable, 
         * which includes all objects which implement java.io.Closeable, can be used as a resource.
         * 
         */
        try (final InputStream stream = Thread.currentThread().getContextClassLoader().
                getResourceAsStream("adapter-subscription.properties")){
//            if (stream == null) {
//                throw new RuntimeException("No properties!!!");
//            }
            this.properties.load(stream);
        }
        catch (final IOException | NullPointerException e) {
            throw new RuntimeException("adapter-subscription.properties: Configuration could not be loaded!" + e.getMessage());
        }
    }
}
