/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.server;

import gov.va.med.nhin.adapter.subscription.web.utils.logging.Log;
import java.io.IOException;
import javax.inject.Inject;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author david
 */
@ServerEndpoint("/SubscriptionWS")
public class SubscriptionWSEndpoint
{
    static private final Logger logger = LoggerFactory.getLogger(SubscriptionWSEndpoint.class.getName());
    
    @Inject
    private SessionCache sessionCache;

    @OnMessage
    public void onMessage(String message, Session session)
    {
        try {
            if (message.startsWith("bind ")) {
                String subscriptionID = message.split(" ")[1];
                if (sessionCache.registerSubscriptionSession(subscriptionID, session)) {
                    session.getBasicRemote().sendText("bound " + subscriptionID);
                }
                else {
                    session.getBasicRemote().sendText("notbound " + subscriptionID);
                }
            }
            else if (message.startsWith("unbind ")) {
                String subscriptionID = message.split(" ")[1];
                if (sessionCache.unregisterSubscriptionSession(subscriptionID, session)) {
                    session.getBasicRemote().sendText("unbound " + subscriptionID);
                }
                else {
                    session.getBasicRemote().sendText("notunbound " + subscriptionID);
                }
            }
            else if (message.startsWith("pong ")) {
                Log.debug(logger, message);
            }
        }
        catch (IOException ioe) {
            // TODO: handle this exception properly.
        }
    }

    @OnClose
    public void onClose(Session session)
    {
        sessionCache.unregisterSession(session);
    }
}
