/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.resourceprovider;

import ca.uhn.fhir.rest.annotation.Create;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.annotation.ResourceParam;
import ca.uhn.fhir.rest.annotation.Update;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import gov.va.med.nhin.adapter.subscription.web.annotations.Created;
import gov.va.med.nhin.adapter.subscription.web.event.SubscriptionEvent;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXSubscription;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Subscription.SubscriptionChannelType;
import gov.va.med.nhin.adapter.subscription.web.proxy.provider.subscription.SubscriptionProvider;
import gov.va.med.nhin.adapter.subscription.web.utils.logging.Log;
import javax.enterprise.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

/**
 *
 * @author david_vetsez
 */
@ApplicationScoped()
@Named("SubscriptionResourceProvider")
public class SubscriptionResourceProvider implements IResourceProvider
{
    private static final Logger logger = LoggerFactory.getLogger(SubscriptionResourceProvider.class);
    
    @Inject
    private SubscriptionProvider subscriptionProvider;
    @Created
    @Inject
    private Event<SubscriptionEvent> createdEvent;

    @Override
    public Class<EHXSubscription> getResourceType()
    {
        return EHXSubscription.class;
    }

    @Create
    public MethodOutcome create(@ResourceParam EHXSubscription resource)
    {
        validate(resource);
        Long subscriptionID = subscriptionProvider.create(resource);
        IdType id = resource.getIdElement();
        MethodOutcome ret = new MethodOutcome(id);
        createdEvent.fire(new SubscriptionEvent(subscriptionID));
        Log.info(logger, "Subscription Event created with ID: " + subscriptionID);
        return ret;
    }

    @Read
    public EHXSubscription read(@IdParam IdType id)
    {
        EHXSubscription ret = subscriptionProvider.read(id);
        return ret;
    }

    @Update
    public MethodOutcome update(@IdParam IdType id, @ResourceParam EHXSubscription subscription)
    {
        subscriptionProvider.update(id.getIdPartAsLong(), subscription);
        Log.debug(logger, "Subscription:" + subscription.getId() + " is being updated");
        return new MethodOutcome(id);
    }

    protected void validate(EHXSubscription subscription)
    {
        // TODO: validate the pieces we need are in request. etc.
        // Throw new UnprocessableEntityException(...) with appropriate info to
        // specify the issue when validation fails.
        
        
        if (!subscription.hasChannel()) {
            throw new UnprocessableEntityException("No notification channel was provided.");
        }

        if (!(subscription.getChannel().getType() != SubscriptionChannelType.RESTHOOK
              || subscription.getChannel().getType() != SubscriptionChannelType.WEBSOCKET)) {
            throw new UnprocessableEntityException("Only rest-hook and websocket channels are suppored.");
        }

        if (!subscription.hasCriteria()) {
            throw new UnprocessableEntityException("No criteria was provided.");
        }

        if (!subscription.hasPatientID()) {
            throw new UnprocessableEntityException("Criteria provided in subscription is not supported.");
        }
        
        if (!subscription.hasAllAssertions()) {
            throw new UnprocessableEntityException("Subscription is missing assertions.");
        }
        Log.debug(logger, "Validation of Subscription for Patient ID : " + subscription.getPatientID());
    }

    public void setSubscriptionProvider(SubscriptionProvider subscriptionProvider)
    {
        this.subscriptionProvider = subscriptionProvider;
    }

    public void setCreatedEvent(Event<SubscriptionEvent> createdEvent)
    {
        this.createdEvent = createdEvent;
    }
}
