/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.resourceprovider;

import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.annotation.RequiredParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.exceptions.NotImplementedOperationException;
import gov.va.med.nhin.adapter.subscription.web.proxy.provider.documentreference.DocumentReferenceProvider;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXDocumentReference;
import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.hl7.fhir.dstu3.model.DocumentReference;
import org.hl7.fhir.dstu3.model.IdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author david_vetsez
 */
@ApplicationScoped()
@Named("DocumentReferenceResourceProvider")
public class DocumentReferenceResourceProvider implements IResourceProvider
{
    @Inject
    private DocumentReferenceProvider documentReferenceProvider;

    @Override
    public Class<EHXDocumentReference> getResourceType()
    {
        return EHXDocumentReference.class;
    }

    @Read
    public DocumentReference read(@IdParam IdType id)
    {
        return documentReferenceProvider.read(id);
    }

    @Search
    public Collection<EHXDocumentReference> getSince(@RequiredParam(name = DocumentReference.SP_PATIENT) StringParam patientID,
                                                     @RequiredParam(name = "_lastUpdated") DateParam lastUpdated)
    {
        if (lastUpdated.getPrefix() == ParamPrefixEnum.GREATERTHAN_OR_EQUALS) {
            return documentReferenceProvider.findByPatientIDAndDocumentReferenceUpdatedOnOrAfter(
                EHXDocumentReference.getPatientID(patientID.getValue()), lastUpdated.getValue());
        }
        else {
            throw new NotImplementedOperationException("Only >= searches are supported.");
        }
    }
}
