/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.resourceprovider;

import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import gov.va.med.nhin.adapter.subscription.web.process.DocumentProcessor;
import gov.va.med.nhin.adapter.subscription.web.proxy.documentretrieve.DocumentRetrieverResponse;
import gov.va.med.nhin.adapter.subscription.web.utils.logging.Log;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.hl7.fhir.dstu3.model.Binary;
import org.hl7.fhir.dstu3.model.IdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author david_vetsez
 */
@ApplicationScoped()
@TransactionManagement(TransactionManagementType.CONTAINER)
@Named("BinaryResourceProvider")
public class BinaryResourceProvider implements IResourceProvider
{
     private static final Logger logger = LoggerFactory.getLogger(BinaryResourceProvider.class);
    @Inject
    private DocumentProcessor documentProcessor;
    
    @Override
    public Class<Binary> getResourceType()
    {
        return Binary.class;
    }

    @Read
    public Binary read(@IdParam IdType id)
    {
        Binary ret = null;
        DocumentRetrieverResponse drr = documentProcessor.getDocument(id.getIdPart());
        if (drr != null) {
            if (drr.isSuccess() && drr.getBinary() != null) {
                ret = drr.getBinary();
            }
            else {
                StringBuilder errorString = new StringBuilder("An error occurred when attempting to retrieve the document.");
                for (String s : drr.getErrors()) {
                    errorString.append("\n").append(s);
                }
                throw new InternalErrorException(errorString.toString());
            }
        }
        Log.debug(logger, "Binary retrieved successfully");
        return ret;
    }

    public void setDocumentProcessor(DocumentProcessor documentProcessor)
    {
        this.documentProcessor = documentProcessor;
    }
}
