/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.resource;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.Extension;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.DocumentReference;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.StringType;

/**
 *
 * @author PII
 */
@ResourceDef(name = "DocumentReference", profile = "http://URL/StructureDefinition/EHXDocumentReference")
public class EHXDocumentReference extends DocumentReference
{
    @Child(name = "homeCommunityId")
    @Extension(url = "http://URL/StructureDefinition/EHXDocumenteReference/homeCommunityId", definedLocally = true, isModifier = false)
    @Description(shortDefinition = "Home Community ID that provided document being referenced.")
    private StringType homeCommunityId;

    @Child(name = "repositoryUniqueId")
    @Extension(url = "http://URL/StructureDefinition/EHXDocumenteReference/repositoryUniqueId", definedLocally = true, isModifier = false)
    @Description(shortDefinition = "Repository Unique ID of referenced document.")
    private StringType repositoryUniqueId;

    @Child(name = "documentUniqueId")
    @Extension(url = "http://URL/StructureDefinition/EHXDocumenteReference/documentUniqueId", definedLocally = true, isModifier = false)
    @Description(shortDefinition = "Document Unique ID of referenced document.")
    private StringType documentUniqueId;

    @Child(name = "subscription")
    @Extension(url = "http://URL/StructureDefinition/EHXDocumenteReference/subscription", definedLocally = true, isModifier = false)
    @Description(shortDefinition = "Reference to subscription which triggered the creation of this DocumentReference.")
    private Reference subscription;

    @Child(name = "documentRetrieved")
    @Extension(url = "http://URL/StructureDefinition/EHXDocumenteReference/documentRetrieved", definedLocally = true, isModifier = false)
    @Description(shortDefinition = "Flag which indicates whether successful RetrieveDocument occurred.")
    private BooleanType documentRetrieved;
    
    public String getHomeCommunityId()
    {
        return homeCommunityId != null ? homeCommunityId.asStringValue() : null;
    }

    public void setHomeCommunityId(String hcid)
    {
        homeCommunityId = new StringType(hcid);
    }

    public StringType getHomeCommunityIdElement()
    {
        return homeCommunityId;
    }

    public void setHomeCommunityIdElement(StringType homeCommunityId)
    {
        this.homeCommunityId = homeCommunityId;
    }

    public String getRepositoryUniqueId()
    {
        return repositoryUniqueId != null ? repositoryUniqueId.asStringValue() : null;
    }

    public void setRepositoryUniqueId(String rid)
    {
        repositoryUniqueId = new StringType(rid);
    }

    public StringType getRepositoryUniqueIdElement()
    {
        return repositoryUniqueId;
    }

    public void setRepositoryUniqueIdElement(StringType repositoryUniqueId)
    {
        this.repositoryUniqueId = repositoryUniqueId;
    }

    public String getDocumentUniqueId()
    {
        return documentUniqueId != null ? documentUniqueId.asStringValue() : null;
    }

    public void setDocumentUniqueId(String did)
    {
        documentUniqueId = new StringType(did);
    }

    public StringType getDocumentUniqueIdElement()
    {
        return documentUniqueId;
    }

    public void setDocumentUniqueIdElement(StringType documentUniqueId)
    {
        this.documentUniqueId = documentUniqueId;
    }

    public Reference getSubscription()
    {
        return subscription;
    }

    public void setSubscription(Reference subscription)
    {
        this.subscription = subscription;
    }

    public BooleanType getDocumentRetrieved()
    {
        return documentRetrieved;
    }

    public void setDocumentRetrieved(BooleanType documentRetrieved)
    {
        this.documentRetrieved = documentRetrieved;
    }

    public boolean hasPatientID()
    {
        return null != getPatientID();
    }

    public String getPatientID()
    {
        return getPatientID(getSubject().getReference());
    }
    
    public static String getPatientID(String criteria)
    {
        final Pattern patientid = Pattern.compile("Patient/(\\d{10}V\\d{6})");
        
        Matcher m = patientid.matcher(criteria);
        return (m.matches() ? m.group(1) : null);
    }
}