/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.proxy.provider.documentreference;

import gov.va.med.nhin.adapter.subscription.web.dao.InMemoryDAO;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXDocumentReference;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.inject.Named;
import org.hl7.fhir.dstu3.model.IdType;

/**
 *
 * @author PII
 */
@Named("InMemoryDocumentReferenceProvider")
@ApplicationScoped()
@Alternative()
public class InMemoryDocumentReferenceProvider implements DocumentReferenceProvider
{
    private InMemoryDAO<EHXDocumentReference> inMemoryDAO = new InMemoryDAO<>();
    
    @Override
    public Long create(EHXDocumentReference resource)
    {
        DocumentReferenceProvider.super.create(resource);
        return inMemoryDAO.store(resource);
    }

    @Override
    public EHXDocumentReference read(Long id)
    {
        return inMemoryDAO.findByID(id);
    }

    @Override
    public EHXDocumentReference read(IdType id)
    {
        return inMemoryDAO.findByResourceID(id.getIdPart());
    }

    @Override
    public void update(Long id, EHXDocumentReference resource)
    {
        DocumentReferenceProvider.super.update(id, resource);
        inMemoryDAO.update(id, resource);
    }

    @Override
    public EHXDocumentReference delete(Long id)
    {
        return inMemoryDAO.delete(id);
    }
    
    @Override
    public List<EHXDocumentReference> findByPatientIDAndDocumentReferenceUpdatedOnOrAfter(String patientID, Date date)
    {
        return inMemoryDAO.find((EHXDocumentReference dr) -> {
            Date lastUpdated = dr.getMeta().getLastUpdated();
            return dr.getPatientID().equals(patientID)
                   && lastUpdated != null
                   && (lastUpdated.equals(date)
                       || lastUpdated.after(date));
        });
    }

    @Override
    public EHXDocumentReference findByBinaryReferenceURL(String url)
    {
        List<EHXDocumentReference> drs = inMemoryDAO.find((EHXDocumentReference dr) -> {
            return true;
        });
        return null;
    }
}
