/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.proxy.provider.documentreference;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import gov.va.med.nhin.adapter.subscription.web.dao.DocumentReferenceDAO;
import gov.va.med.nhin.adapter.subscription.web.entity.DocumentReference;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXDocumentReference;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.LockModeType;
import javax.transaction.Transactional;
import org.hl7.fhir.dstu3.model.IdType;

/**
 *
 * @author PII
 */
@Named("DAODocumentReferenceProvider")
@ApplicationScoped()
public class DAODocumentReferenceProvider implements DocumentReferenceProvider
{
    @Inject
    private DocumentReferenceDAO documentReferenceDAO;
    @Inject
    private FhirContext fhirContext;

    @Override
    @Transactional
    public Long create(EHXDocumentReference resource)
    {
        DocumentReferenceProvider.super.create(resource);
        DocumentReference entity = createEntityFromResource(resource);
        entity.setCreatedTime(new Date());
        documentReferenceDAO.store(entity);
        Long ret = entity.getDocumentReferenceId().longValue();
        resource.setUserData("documentReferenceID", ret);
        return ret;
    }

    @Override
    public EHXDocumentReference read(Long id)
    {
        DocumentReference entity = documentReferenceDAO.findByDocumentReferenceID(BigDecimal.valueOf(id));
        return createResourceFromEntity(entity);
    }

    @Override
    public EHXDocumentReference readAndLock(Long id)
    {
        DocumentReference entity = documentReferenceDAO.findByDocumentReferenceID(BigDecimal.valueOf(id), LockModeType.PESSIMISTIC_WRITE);
        return createResourceFromEntity(entity);
    }
    
    @Override
    public EHXDocumentReference read(IdType id)
    {
        DocumentReference entity = documentReferenceDAO.findByResourceID(id.getIdPart());
        return createResourceFromEntity(entity);
    }

    @Override
    @Transactional
    public boolean readWithUpdate(Long id, Function<EHXDocumentReference, Boolean> function)
    {
        return DocumentReferenceProvider.super.readWithUpdate(id, function);
    }

    @Override
    @Transactional
    public void update(Long id, EHXDocumentReference resource)
    {
        DocumentReferenceProvider.super.update(id, resource);
        DocumentReference entity = documentReferenceDAO.findByDocumentReferenceID(BigDecimal.valueOf(id));
        updateEntityFromResource(resource, entity);
        documentReferenceDAO.update(entity);
    }

    @Override
    public EHXDocumentReference delete(Long id)
    {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public List<EHXDocumentReference> findByPatientIDAndDocumentReferenceUpdatedOnOrAfter(String patientID, Date date)
    {
        List<EHXDocumentReference> ret = new ArrayList<>();
        List<gov.va.med.nhin.adapter.subscription.web.entity.DocumentReference> entities
                = documentReferenceDAO.findByPatientIDAndLastUpdatedTime(patientID, date);
        entities.forEach((entity) -> {
            ret.add(createResourceFromEntity(entity));
        });
        return ret;
    }

    @Override
    public EHXDocumentReference findByBinaryReferenceURL(String url)
    {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
    
    private DocumentReference createEntityFromResource(EHXDocumentReference resource)
    {
        DocumentReference ret = new DocumentReference();
        updateEntityFromResource(resource, ret);
        return ret;
    }
    
    private DocumentReference updateEntityFromResource(EHXDocumentReference resource, DocumentReference ret)
    {
        ret.setResourceId(resource.getIdElement().getIdPart());
        ret.setLastUpdatedTime(resource.getMeta().getLastUpdated());
        ret.setPatientId(resource.getPatientID());
        IParser jsonParser = fhirContext.newJsonParser();
        try {
            ret.setFhirResource(jsonParser.encodeResourceToString(resource).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("You're using an unsupported encoding.  FIX IT NOW!!!", uee);
        }
        return ret;
    }

    private EHXDocumentReference createResourceFromEntity(DocumentReference entity)
    {
        EHXDocumentReference ret = null;
        if (entity != null) {
            IParser jsonParser = fhirContext.newJsonParser();
            try {
                ret = jsonParser.parseResource(EHXDocumentReference.class, new String(entity.getFhirResource(), "UTF-8"));
                ret.setUserData("documentReferenceID", entity.getDocumentReferenceId().longValue());
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException("You're using an unsupported encoding.  FIX IT NOW!!!", uee);
            }
        }
        return ret;
    }

    public void setDocumentReferenceDAO(DocumentReferenceDAO documentReferenceDAO)
    {
        this.documentReferenceDAO = documentReferenceDAO;
    }

    public void setFhirContext(FhirContext fhirContext)
    {
        this.fhirContext = fhirContext;
    }
}
