/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.proxy.provider.binary;

import gov.va.med.nhin.adapter.subscription.web.dao.InMemoryDAO;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.inject.Named;
import org.hl7.fhir.dstu3.model.Binary;
import org.hl7.fhir.dstu3.model.IdType;

/**
 *
 * @author PII
 */
@Named("InMemoryBinaryProvider")
@ApplicationScoped()
@Alternative()
public class InMemoryBinaryProvider implements BinaryProvider
{
    private InMemoryDAO<Binary> inMemoryDAO = new InMemoryDAO<>();
    
    @Override
    public Long create(Binary resource)
    {
        BinaryProvider.super.create(resource);
        return inMemoryDAO.store(resource);
    }

    @Override
    public Binary read(Long id)
    {
        return inMemoryDAO.findByID(id);
    }

    @Override
    public Binary read(IdType id)
    {
        return inMemoryDAO.findByResourceID(id.getIdPart());
    }

    @Override
    public void update(Long id, Binary resource)
    {
        BinaryProvider.super.update(id, resource);
        inMemoryDAO.update(id, resource);
    }

    @Override
    public Binary delete(Long id)
    {
        return inMemoryDAO.delete(id);
    }
}
