/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.proxy.provider.binary;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import gov.va.med.nhin.adapter.subscription.web.dao.BinaryDAO;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.function.Function;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.hl7.fhir.dstu3.model.Binary;
import org.hl7.fhir.dstu3.model.IdType;

/**
 *
 * @author PII
 */
@Named("DAOBinaryProvider")
@ApplicationScoped()
public class DAOBinaryProvider implements BinaryProvider
{
    @Inject
    private BinaryDAO binaryDAO;
    @Inject
    private FhirContext fhirContext;

    @Override
    @Transactional
    public Long create(Binary resource)
    {
        BinaryProvider.super.create(resource);
        gov.va.med.nhin.adapter.subscription.web.entity.Binary entity
            = createEntityFromResource(resource);
        entity.setCreatedTime(new Date());
        binaryDAO.store(entity);
        Long ret = entity.getBinaryId().longValue();
        resource.setUserData("binaryID", ret);
        return ret;
    }

    @Override
    public Binary read(Long id)
    {
        gov.va.med.nhin.adapter.subscription.web.entity.Binary entity
            = binaryDAO.findByBinaryID(BigDecimal.valueOf(id));
        return createResourceFromEntity(entity);
    }

    @Override
    public Binary read(IdType id)
    {
        gov.va.med.nhin.adapter.subscription.web.entity.Binary entity
            = binaryDAO.findByResourceID(id.getIdPart());
        return createResourceFromEntity(entity);
    }

    @Override
    @Transactional
    public boolean readWithUpdate(Long id, Function<Binary, Boolean> function)
    {
        return BinaryProvider.super.readWithUpdate(id, function);
    }
    
    @Override
    @Transactional
    public void update(Long id, Binary resource)
    {
        BinaryProvider.super.update(id, resource);
        gov.va.med.nhin.adapter.subscription.web.entity.Binary entity
            = createEntityFromResource(resource);
        entity.setBinaryId(BigDecimal.valueOf(id));
        binaryDAO.update(entity);
    }

    @Override
    public Binary delete(Long id)
    {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    private gov.va.med.nhin.adapter.subscription.web.entity.Binary createEntityFromResource(Binary resource)
    {
        gov.va.med.nhin.adapter.subscription.web.entity.Binary ret = new gov.va.med.nhin.adapter.subscription.web.entity.Binary();
        ret.setResourceId(resource.getIdElement().getIdPart());
        ret.setLastUpdatedTime(resource.getMeta().getLastUpdated());
        IParser jsonParser = fhirContext.newJsonParser();
        try {
            ret.setFhirResource(jsonParser.encodeResourceToString(resource).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("You're using an unsupported encoding.  FIX IT NOW!!!", uee);
        }
        return ret;
    }

    private Binary createResourceFromEntity(gov.va.med.nhin.adapter.subscription.web.entity.Binary entity)
    {
        Binary ret = null;
        if (entity != null) {
            IParser jsonParser = fhirContext.newJsonParser();
            try {
                ret = jsonParser.parseResource(Binary.class, new String(entity.getFhirResource(), "UTF-8"));
                ret.setUserData("binaryID", entity.getBinaryId().longValue());
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException("You're using an unsupported encoding.  FIX IT NOW!!!", uee);
            }
        }
        return ret;
    }

    public void setBinaryDAO(BinaryDAO binaryDAO)
    {
        this.binaryDAO = binaryDAO;
    }

    public void setFhirContext(FhirContext fhirContext)
    {
        this.fhirContext = fhirContext;
    }
}
